/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.function.Supplier;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.PacketGridSync;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGridToServer
extends PacketGridSync {
    private ItemStack[] stacks = new ItemStack[0];

    public void toBytes(PacketBuffer buf) {
        this.convertToBytes(buf);
        buf.writeInt(this.stacks.length);
        for (ItemStack stack : this.stacks) {
            buf.func_150788_a(stack);
        }
    }

    public PacketGridToServer() {
    }

    public PacketGridToServer(PacketBuffer buf) {
        this.convertFromBytes(buf);
        int len = buf.readInt();
        this.stacks = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            this.stacks[i] = buf.func_150791_c();
        }
    }

    public PacketGridToServer(BlockPos pos, DimensionId type, CraftingGrid grid) {
        this.init(pos, type, grid);
        this.stacks = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            this.stacks[i] = grid.getCraftingGridInventory().getStackInSlot(i);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            World world = player.func_130014_f_();
            CraftingGridProvider provider = this.handleMessage((World)WorldTools.getWorld((World)world, (DimensionId)this.type), (PlayerEntity)player);
            if (provider != null) {
                CraftingGridInventory inventory = provider.getCraftingGrid().getCraftingGridInventory();
                for (int i = 0; i < 10; ++i) {
                    inventory.setStackInSlot(i, this.stacks[i]);
                }
                provider.markInventoryDirty();
            }
        });
        ctx.setPacketHandled(true);
    }
}

