/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.items;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.storage.IStorageModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.storage.StorageEntry;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;

public class StorageModuleItem
extends Item
implements INBTPreservingIngredient,
IStorageModuleItem {
    public static final int STORAGE_TIER1 = 0;
    public static final int STORAGE_TIER2 = 1;
    public static final int STORAGE_TIER3 = 2;
    public static final int STORAGE_TIER4 = 3;
    public static final int STORAGE_REMOTE = 6;
    public static final int[] MAXSIZE = new int[]{100, 200, 300, 500, 0, 0, -1};
    private final int tier;
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"items", stack -> !this.isRemoteModule() && this.hasUUID((ItemStack)stack), this::getContentsString), TooltipBuilder.key((String)"message.rftoolsstorage.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> this.isRemoteModule()), TooltipBuilder.parameter((String)"info", stack -> !this.isRemoteModule(), stack -> Integer.toString(this.getMax())), TooltipBuilder.parameter((String)"remoteid", stack -> this.isRemoteModule(), stack -> {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("id")) {
            int id = tag.func_74762_e("id");
            return Integer.toString(id);
        }
        return "<unlinked>";
    }), TooltipBuilder.parameter((String)"uuid", stack -> {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_186855_b("uuid")) {
            return tag.func_186857_a("uuid").toString();
        }
        return "<unset>";
    }), TooltipBuilder.parameter((String)"version", stack -> {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return Integer.toString(tag.func_74762_e("version"));
        }
        return "<unset>";
    }), TooltipBuilder.parameter((String)"items", stack -> !this.isRemoteModule() && this.hasUUID((ItemStack)stack), this::getContentsString)}).infoAdvanced(new InfoLine[]{TooltipBuilder.parameter((String)"advanced", this::getAdvancedInfo)});

    private String getContentsString(ItemStack stack) {
        StorageEntry storage = this.getStorage(stack);
        if (storage != null) {
            NonNullList<ItemStack> stacks = storage.getStacks();
            int cnt = 0;
            for (ItemStack s : stacks) {
                if (s.func_190926_b()) continue;
                ++cnt;
            }
            return Integer.toString(cnt) + "/" + Integer.toString(this.getMax());
        }
        return "<unknown>";
    }

    private String getAdvancedInfo(ItemStack stack) {
        StorageEntry storage = this.getStorage(stack);
        if (storage != null) {
            String createdBy = storage.getCreatedBy();
            String info = "";
            info = createdBy != null && !createdBy.isEmpty() ? info + "Created by " + createdBy : info + "Unknown creator";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date creationTime = new Date(storage.getCreationTime());
            Date updateTime = new Date(storage.getUpdateTime());
            info = info + ", Creation time " + dateFormat.format(creationTime);
            info = info + ", Update time " + dateFormat.format(updateTime);
            return info;
        }
        return "<unknown>";
    }

    private StorageEntry getStorage(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (tag.func_186855_b("uuid")) {
            UUID uuid = tag.func_186857_a("uuid");
            int version = tag.func_74762_e("version");
            return RFToolsStorage.setup.clientStorageHolder.getStorage(uuid, version);
        }
        return null;
    }

    private boolean isRemoteModule() {
        return this.getMax() == -1;
    }

    private boolean hasUUID(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_186855_b("uuid");
    }

    public StorageModuleItem(int tier) {
        super(new Item.Properties().func_200917_a(1).func_200918_c(0).func_200916_a(RFToolsStorage.setup.getTab()));
        this.tier = tier;
    }

    private int getMax() {
        return MAXSIZE[this.tier];
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity player) {
        CompoundNBT tag;
        if (player != null && !(tag = stack.func_196082_o()).func_74764_b("createdBy")) {
            tag.func_74778_a("createdBy", player.func_200200_C_().getString());
        }
    }

    public static UUID getOrCreateUUID(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof StorageModuleItem)) {
            throw new RuntimeException("This is not supposed to happen! Needs to be a storage item!");
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_186855_b("uuid")) {
            nbt.func_186854_a("uuid", UUID.randomUUID());
            nbt.func_74768_a("version", 0);
        }
        return nbt.func_186857_a("uuid");
    }

    public static String getCreatedBy(ItemStack storageCard) {
        if (storageCard.func_77942_o()) {
            return storageCard.func_77978_p().func_74779_i("createdBy");
        }
        return null;
    }

    public static int getVersion(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("version");
        }
        return 0;
    }

    public static int getSize(ItemStack storageCard) {
        if (storageCard.func_77973_b() instanceof StorageModuleItem) {
            int tier = ((StorageModuleItem)storageCard.func_77973_b()).tier;
            return MAXSIZE[tier];
        }
        return 0;
    }

    public Collection<String> getTagsToPreserve() {
        return Arrays.asList("uuid");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Place this module in a storage module tablet to access contents"));
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(itemStack, worldIn, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(new ResourceLocation("rftoolsstorage", "storage_module"), itemStack, list, flags);
    }
}

