/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import java.util.Collection;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.ItemStackTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class DumpScreenModule
implements IScreenModule<IModuleData> {
    public static int COLS = 7;
    public static int ROWS = 4;
    private ItemStackList stacks = ItemStackList.create((int)(COLS * ROWS));
    protected DimensionId dim = DimensionId.overworld();
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private boolean matchingTag = false;

    public IModuleDataBoolean getData(IScreenDataHelper helper, World worldObj, long millis) {
        return null;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (!tagCompound.func_74764_b("stack" + i)) continue;
                this.stacks.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("stack" + i)));
            }
        }
    }

    protected void setupCoordinateFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        this.matchingTag = tagCompound.func_74767_n("matchingTag");
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
            if (Objects.equals(dim, this.dim)) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    private boolean isShown(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (this.isItemEqual(stack, s)) {
                return true;
            }
            if (!this.matchingTag || !ItemStackTools.hasCommonTag((Collection)s.func_77973_b().getTags())) continue;
            return true;
        }
        return false;
    }

    public boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.func_190926_b()) {
            return false;
        }
        return thisItem.func_77969_a(other);
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
        if (!clicked || player == null) {
            return;
        }
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Module is not linked to storage scanner!"), false);
            return;
        }
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(world, this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return;
        }
        int xoffset = 5;
        if (x >= xoffset) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                if (!this.isShown(player.field_71071_by.func_70301_a(i))) continue;
                ItemStack stack = scannerTileEntity.injectStackFromScreen(player.field_71071_by.func_70301_a(i), player);
                player.field_71071_by.func_70299_a(i, stack);
            }
            player.field_71070_bA.func_75142_b();
            return;
        }
    }

    public int getRfPerTick() {
        return (Integer)StorageScannerConfiguration.DUMP_RFPERTICK.get();
    }
}

