/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;
import slimeknights.mantle.client.gui.book.Textures;

public class BoxRenderer {
    public static final int TEX_SIZE = 128;

    public static void drawBox(int x, int y, int width, int height, int index) {
        BoxRenderer.drawBox(x, y, width, height, index, 16, 16, 4, 4, 2, 2);
    }

    public static void drawBox(int x, int y, int width, int height, int index, int sprW, int sprH, int segW, int segH, int segGW, int segGH) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Textures.TEX_BOX);
        int sx = x;
        int sy = y;
        for (int i = 0; i < 3; ++i) {
            int sgW = width - segW * 2;
            if (i % 2 == 0) {
                sgW = segW;
            }
            for (int j = 0; j < 3; ++j) {
                int sgH = height - segH * 2;
                if (j % 2 == 0) {
                    sgH = segH;
                }
                int[] matrix = BoxRenderer.getTextureMatrixCoords(index, sprW, sprH, segW, segH, segGW, segGH, i + j * 3);
                Gui.func_152125_a((int)sx, (int)sy, (float)matrix[0], (float)matrix[1], (int)segW, (int)segH, (int)sgW, (int)sgH, (float)128.0f, (float)128.0f);
                sy += sgH;
            }
            sx += sgW;
            sy = y;
        }
    }

    public static int[] getTextureMatrixCoords(int index, int sprW, int sprH, int segW, int segH, int segGW, int segGH, int segId) {
        int totalWidth = segW * 3 + segGW * 2;
        int totalHeight = segH * 3 + segGH * 2;
        return BoxRenderer.getTextureMatrixCoords(index % (256 / sprW) * sprW + (sprW / 2 - totalWidth / 2), MathHelper.func_76141_d((float)((float)index / (256.0f / (float)sprH))) * sprH + (sprH / 2 - totalHeight / 2), segW, segH, segGW, segGH, segId);
    }

    public static int[] getTextureMatrixCoords(int u, int v, int segW, int segH, int segGW, int segGH, int segId) {
        int[] coords = new int[4];
        int col = segId % 3;
        int row = MathHelper.func_76141_d((float)((float)segId / 3.0f));
        coords[0] = u + col * segW + col * segGW;
        coords[1] = v + row * segH + row * segGH;
        coords[2] = coords[0] + segW;
        coords[3] = coords[1] + segH;
        return coords;
    }
}

