/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.inventory.InventoryUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemUtils {
    public static boolean isPlayerHoldingSomething(EntityPlayer player) {
        return player.func_184614_ca() != null || player.func_184592_cb() != null;
    }

    public static ItemStack getHeldStack(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack == null) {
            stack = player.func_184592_cb();
        }
        return stack;
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack, double velocity) {
        double xVelocity = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double yVelocity = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double zVelocity = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + xVelocity, (double)pos.func_177956_o() + yVelocity, (double)pos.func_177952_p() + zVelocity, stack);
        entityItem.func_174867_a(10);
        world.func_72838_d((Entity)entityItem);
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        ItemUtils.dropItem(world, pos, stack, 0.7);
    }

    public static void dropInventory(World world, BlockPos pos, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            ItemUtils.dropItem(world, pos, stack);
        }
    }

    public static ItemStack copyStack(ItemStack stack, int stackSize) {
        return InventoryUtils.copyStack(stack, stackSize);
    }

    public static void ejectItem(World world, BlockPos pos, ItemStack stack, EnumFacing dir) {
        pos.func_177972_a(dir);
        EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        switch (dir) {
            case DOWN: {
                entity.field_70181_x = -0.3;
                break;
            }
            case UP: {
                entity.field_70181_x = 0.3;
                break;
            }
            case NORTH: {
                entity.field_70179_y = -0.3;
                break;
            }
            case SOUTH: {
                entity.field_70179_y = 0.3;
                break;
            }
            case WEST: {
                entity.field_70159_w = -0.3;
                break;
            }
            case EAST: {
                entity.field_70159_w = 0.3;
                break;
            }
        }
        entity.func_174867_a(10);
        world.func_72838_d((Entity)entity);
    }

    public static void ejectItems(World world, BlockPos pos, List<ItemStack> stacks, EnumFacing dir) {
        for (ItemStack stack : stacks) {
            ItemUtils.ejectItem(world, pos, stack, dir);
        }
    }

    public static int getBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack);
    }

    public static int compareItemStack(ItemStack stack1, ItemStack stack2) {
        int itemStack2ID;
        int itemStack1ID = Item.func_150891_b((Item)stack1.func_77973_b());
        return itemStack1ID != (itemStack2ID = Item.func_150891_b((Item)stack1.func_77973_b())) ? itemStack1ID - itemStack2ID : (stack1.func_77952_i() == stack2.func_77952_i() ? 0 : (stack1.func_77973_b().func_77614_k() ? stack1.func_77952_i() - stack2.func_77952_i() : 0));
    }

    public static boolean areStacksSameType(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77952_i() == stack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1);
    }

    public static boolean areStacksSameTypeCrafting(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == stack2.func_77952_i() || stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE || stack1.func_77973_b().func_77645_m());
    }
}

