/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.log;

import com.agricraft.agricore.config.AgriConfigCategory;
import com.agricraft.agricore.config.AgriConfigurable;
import com.agricraft.agricore.config.AgriConfigurableInstance;
import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.log.AgriLogAdapter;

public class AgriLogger
implements AgriConfigurableInstance {
    private final AgriLogAdapter adapter;
    private final Object source;
    @AgriConfigurable(key="${log} Logging", category=AgriConfigCategory.LOGGING, comment="Set to true to enable logging on the ${log} channel.")
    private boolean enabled = true;

    AgriLogger(AgriLogAdapter adapter, Object source) {
        this.adapter = adapter;
        this.source = source;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void all(Object format, Object ... objects) {
        if (this.enabled) {
            this.adapter.all(this.source, AgriCore.getTranslator().translate(format), objects);
        }
    }

    public void severe(Object format, Object ... objects) {
        if (this.enabled) {
            this.adapter.severe(this.source, AgriCore.getTranslator().translate(format), objects);
        }
    }

    public void info(Object format, Object ... objects) {
        if (this.enabled) {
            this.adapter.info(this.source, AgriCore.getTranslator().translate(format), objects);
        }
    }

    public void warn(Object format, Object ... objects) {
        if (this.enabled) {
            this.adapter.warn(this.source, AgriCore.getTranslator().translate(format), objects);
        }
    }

    public void debug(Object format, Object ... objects) {
        if (this.enabled) {
            this.adapter.debug(this.source, AgriCore.getTranslator().translate(format), objects);
        }
    }

    public void error(Object format, Object ... objects) {
        if (this.enabled) {
            this.adapter.error(this.source, AgriCore.getTranslator().translate(format), objects);
        }
    }

    public void trace(Exception e) {
        if (this.enabled) {
            this.adapter.trace(this.source, e);
        }
    }

    @Override
    public String resolve(String input) {
        return input.replaceAll("\\$\\{log\\}", String.valueOf(this.source));
    }
}

