/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriCondition;
import com.agricraft.agricore.plant.AgriSoil;
import com.agricraft.agricore.util.TypeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AgriRequirement {
    private final int min_light;
    private final int max_light;
    private final List<String> soils;
    private final List<AgriCondition> conditions;

    public AgriRequirement() {
        this.min_light = 10;
        this.max_light = 16;
        this.soils = new ArrayList<String>();
        this.conditions = new ArrayList<AgriCondition>();
    }

    public AgriRequirement(List<String> soils, List<AgriCondition> conditions, int min_light, int max_light) {
        this.soils = new ArrayList<String>(soils);
        this.conditions = conditions;
        this.min_light = 10;
        this.max_light = 16;
    }

    public int getMinLight() {
        return this.min_light;
    }

    public int getMaxLight() {
        return this.max_light;
    }

    public List<AgriSoil> getSoils() {
        return this.soils.stream().map(AgriCore.getSoils()::getSoil).filter(TypeHelper::isNonNull).collect(Collectors.toList());
    }

    public List<AgriCondition> getConditions() {
        return new ArrayList<AgriCondition>(this.conditions);
    }

    public boolean validate() {
        this.soils.removeIf(soil -> {
            if (!AgriCore.getSoils().hasSoil((String)soil)) {
                AgriCore.getCoreLogger().info("Invalid Requirement: Invalid Soil: {0}! Removing!", soil);
                return true;
            }
            return false;
        });
        for (AgriCondition condition : this.conditions) {
            if (condition.validate()) continue;
            AgriCore.getCoreLogger().info("Invalid Requirement: Invalid Condition!", condition);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nRequirement:");
        sb.append("\n\t- Light:");
        sb.append("\n\t\t- Min: ").append(this.min_light);
        sb.append("\n\t\t- Max: ").append(this.max_light);
        sb.append("\n\t- Soil:");
        this.soils.forEach(e -> sb.append("\n\t\t- AgriSoil: ").append((String)e));
        sb.append("\n\t- Conditions:");
        this.conditions.forEach(e -> sb.append("\n\t\t- ").append(e.toString().replaceAll("\n", "\n\t\t").trim()));
        return sb.toString();
    }
}

