/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import com.infinityraider.agricraft.api.v1.requirement.ICondition;
import com.infinityraider.agricraft.api.v1.util.BlockRange;
import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCondition
implements ICondition {
    private final BlockRange range;
    private final FuzzyStack stack;
    private final int amount;
    private final int volume;

    public BlockCondition(FuzzyStack stack, BlockRange range) {
        this.amount = stack.toStack().field_77994_a;
        this.volume = range.getVolume();
        if (this.amount < 1) {
            throw new IndexOutOfBoundsException("The required amount of blocks must be greater than zero!");
        }
        if (this.amount > this.volume) {
            throw new IndexOutOfBoundsException("Required amount of blocks exceeds volume of range!");
        }
        this.range = range;
        this.stack = stack;
    }

    public FuzzyStack getStack() {
        return this.stack;
    }

    public BlockRange getRange() {
        return this.range;
    }

    @Override
    public boolean isMet(IBlockAccess world, BlockPos pos) {
        return new BlockRange(this.range, pos).stream().map(arg_0 -> ((IBlockAccess)world).func_180495_p(arg_0)).map(FuzzyStack::from).map(o -> o.orElse(null)).filter(this.stack::equals).skip(this.amount - 1).findAny().isPresent();
    }

    @Override
    public void addDescription(List<String> lines) {
        lines.add("Required Blocks");
    }

    @Override
    public int getComplexity() {
        return this.volume;
    }
}

