/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.util;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockRange
implements Iterable<BlockPos> {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public BlockRange(@Nonnull BlockRange range, @Nonnull BlockPos pos) {
        this(range.getMin().func_177971_a((Vec3i)pos), range.getMax().func_177971_a((Vec3i)pos));
    }

    public BlockRange(@Nonnull BlockPos center, int radius) {
        this(center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), radius);
    }

    public BlockRange(@Nonnull BlockPos min, @Nonnull BlockPos max) {
        this(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public BlockRange(int x, int y, int z, int radius) {
        this(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
    }

    public BlockRange(int x1, int y1, int z1, int x2, int y2, int z2) {
        if (x1 < x2) {
            this.minX = x1;
            this.maxX = x2;
        } else {
            this.minX = x2;
            this.maxX = x1;
        }
        if (y1 < y2) {
            this.minY = y1;
            this.maxY = y2;
        } else {
            this.minY = y2;
            this.maxY = y1;
        }
        if (z1 < z2) {
            this.minZ = z1;
            this.maxZ = z2;
        } else {
            this.minZ = z2;
            this.maxZ = z1;
        }
    }

    @Nonnull
    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    @Nonnull
    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public int getVolume() {
        return (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
    }

    public boolean contains(BlockPos pos) {
        return pos.func_177958_n() >= this.minX && pos.func_177956_o() >= this.minY && pos.func_177952_p() >= this.minZ && pos.func_177958_n() <= this.maxX && pos.func_177956_o() <= this.maxY && pos.func_177952_p() <= this.maxZ;
    }

    public boolean intersects(BlockRange range) {
        return this.minX < range.maxX && this.maxX > range.minX && this.minY < range.maxY && this.maxY > range.minY && this.minZ < range.maxZ && this.maxZ > range.minZ;
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return new BlockRangeIterator(this);
    }

    @Nonnull
    public Stream<BlockPos> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public class BlockRangeIterator
    implements Iterator<BlockPos> {
        private int x;
        private int y;
        private int z;
        private final BlockRange range;

        public BlockRangeIterator(BlockRange range) {
            this.range = Objects.requireNonNull(range, "You cannot iterate over a range that doesn't exist!");
            this.x = range.minX;
            this.y = range.minY;
            this.z = range.minZ;
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.range.getMaxX() && this.y <= this.range.getMaxY() && this.z <= this.range.getMaxZ();
        }

        @Override
        @Nonnull
        public BlockPos next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            BlockPos pos = new BlockPos(this.x, this.y, this.z);
            ++this.x;
            if (this.x > this.range.maxX) {
                this.x = this.range.minX;
                ++this.y;
                if (this.y > this.range.maxY) {
                    this.y = this.range.minY;
                    ++this.z;
                }
            }
            return pos;
        }
    }
}

