/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks;

import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderWaterPad;
import com.infinityraider.agricraft.utility.FluidHandlerBlockWrapper;
import com.infinityraider.agricraft.utility.IFluidHandlerBlock;
import com.infinityraider.infinitylib.block.BlockCustomRenderedBase;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.block.blockstate.SidedConnection;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWaterPad
extends BlockCustomRenderedBase
implements IFluidHandlerBlock {
    public static final AxisAlignedBB WATER_PAD_BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockWaterPad() {
        super("water_pad", Material.field_151578_c);
        this.func_149711_c(0.5f);
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[]{AgriProperties.POWERED};
    }

    protected IUnlistedProperty[] getUnlistedPropertyArray() {
        return new IUnlistedProperty[]{AgriProperties.CONNECTIONS};
    }

    public IBlockState func_176203_a(int meta) {
        return AgriProperties.POWERED.applyToBlockState(this.func_176223_P(), (Comparable)Boolean.valueOf(meta != 0));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        SidedConnection connection = new SidedConnection();
        EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
        int n = enumFacingArray.length;
        for (int i = 0; i < n; ++i) {
            EnumFacing facing;
            IBlockState stateAt = world.func_180495_p(pos.func_177972_a(facing = enumFacingArray[i]));
            connection.setConnected(facing, stateAt.func_177230_c() == state.func_177230_c());
        }
        return ((IExtendedBlockState)state).withProperty(AgriProperties.CONNECTIONS, (Object)connection);
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)AgriProperties.POWERED.getValue(state) != false ? 0 : 1;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Blocks.field_150346_d.getDrops(world, pos, Blocks.field_150346_d.func_176223_P(), fortune);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WATER_PAD_BOUNDS;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        return FluidUtil.interactWithFluidHandler((ItemStack)stack, (IFluidHandler)new FluidHandlerBlockWrapper(this, world, pos), (EntityPlayer)player);
    }

    @Override
    public IFluidTankProperties[] getTankProperties(World world, BlockPos pos, IBlockState state) {
        return new IFluidTankProperties[0];
    }

    @Override
    public int fill(World world, BlockPos pos, IBlockState state, FluidStack fluid, boolean doFill) {
        if (!((Boolean)AgriProperties.POWERED.getValue(state)).booleanValue() && fluid != null && fluid.amount == 1000 && fluid.getFluid().equals(FluidRegistry.WATER)) {
            if (doFill) {
                world.func_175656_a(pos, AgriProperties.POWERED.applyToBlockState(state, (Comparable)Boolean.valueOf(true)));
            }
            return 1000;
        }
        return 0;
    }

    @Override
    public FluidStack drain(World world, BlockPos pos, IBlockState state, FluidStack fluid, boolean doDrain) {
        if (((Boolean)AgriProperties.POWERED.getValue(state)).booleanValue() && fluid != null && fluid.amount >= 1000 && fluid.getFluid().equals(FluidRegistry.WATER)) {
            if (doDrain) {
                world.func_175656_a(pos, AgriProperties.POWERED.applyToBlockState(state, (Comparable)Boolean.valueOf(false)));
            }
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        return null;
    }

    @Override
    public FluidStack drain(World world, BlockPos pos, IBlockState state, int amount, boolean doDrain) {
        if (((Boolean)AgriProperties.POWERED.getValue(state)).booleanValue() && amount >= 1000) {
            if (doDrain) {
                world.func_175656_a(pos, AgriProperties.POWERED.applyToBlockState(state, (Comparable)Boolean.valueOf(false)));
            }
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderWaterPad getRenderer() {
        return new RenderWaterPad(this);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }
}

