/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.blocks.irrigation.AbstractBlockWaterChannel;
import com.infinityraider.agricraft.crafting.CustomWoodRecipeHelper;
import com.infinityraider.agricraft.renderers.blocks.RenderChannel;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.RegisterHelper;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockWaterChannel
extends AbstractBlockWaterChannel<TileEntityChannel>
implements IRecipeRegister {
    protected static final float MIN = 0.25f;
    protected static final float MAX = 0.75f;
    protected static final double EXPANSION = 0.015625;
    public static final AxisAlignedBB CENTER_BOX = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_186662_g(0.015625);
    public static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.3125).func_186662_g(0.015625);
    public static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.6875, 0.25, 0.25, 1.0, 0.75, 0.75).func_186662_g(0.015625);
    public static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.25, 0.25, 0.6875, 0.75, 0.75, 1.0).func_186662_g(0.015625);
    public static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.0, 0.25, 0.25, 0.3125, 0.75, 0.75).func_186662_g(0.015625);

    public BlockWaterChannel() {
        super("normal");
    }

    public TileEntityChannel createNewTileEntity(World world, int meta) {
        return new TileEntityChannel();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        Optional tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannel.class);
        BlockWaterChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)CENTER_BOX);
        if (tile.isPresent()) {
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.NORTH)) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)NORTH_BOX);
            }
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.EAST)) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)EAST_BOX);
            }
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.SOUTH)) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)SOUTH_BOX);
            }
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.WEST)) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)WEST_BOX);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannel.class);
        AxisAlignedBB selection = CENTER_BOX;
        if (tile.isPresent()) {
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.NORTH)) {
                selection = selection.func_111270_a(NORTH_BOX);
            }
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.EAST)) {
                selection = selection.func_111270_a(EAST_BOX);
            }
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.SOUTH)) {
                selection = selection.func_111270_a(SOUTH_BOX);
            }
            if (((TileEntityChannel)tile.get()).hasNeighbor(EnumFacing.WEST)) {
                selection = selection.func_111270_a(WEST_BOX);
            }
        }
        return selection;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderChannel getRenderer() {
        return new RenderChannel<BlockWaterChannel, TileEntityChannel>(this, new TileEntityChannel());
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void registerRecipes() {
        if (this.isEnabled()) {
            RegisterHelper.removeRecipe((ItemStack)new ItemStack(Items.field_151054_z));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151054_z, 4), new Object[]{"w w", " w ", Character.valueOf('w'), "slabWood"}));
            CustomWoodRecipeHelper.registerCustomWoodRecipe((Block)this, 6, true, "w w", " w ", Character.valueOf('w'), "MATERIAL_PARAMETER");
        }
    }
}

