/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.blocks.irrigation.AbstractBlockWaterChannel;
import com.infinityraider.agricraft.crafting.CustomWoodRecipeHelper;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.items.blocks.ItemBlockCustomWood;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderChannelValve;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannelValve;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWaterChannelValve
extends AbstractBlockWaterChannel<TileEntityChannelValve>
implements IRecipeRegister {
    public static final AxisAlignedBB BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockWaterChannelValve() {
        super("valve");
    }

    @Override
    protected InfinityProperty[] getPropertyArray() {
        InfinityProperty[] properties = Arrays.copyOf(super.getPropertyArray(), super.getPropertyArray().length + 1);
        properties[properties.length - 1] = AgriProperties.POWERED;
        return properties;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)worldIn, (BlockPos)pos, TileEntityChannelValve.class);
        return AgriProperties.POWERED.applyToBlockState(super.func_176221_a(state, worldIn, pos), (Comparable)Boolean.valueOf(tile.isPresent() && ((TileEntityChannelValve)tile.get()).isPowered()));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        super.func_189540_a(state, world, pos, block);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityChannelValve) {
            TileEntityChannelValve valve = (TileEntityChannelValve)te;
            valve.updatePowerStatus();
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityChannelValve) {
            ((TileEntityChannelValve)te).updatePowerStatus();
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public TileEntityChannelValve createNewTileEntity(World world, int meta) {
        return new TileEntityChannelValve();
    }

    @SideOnly(value=Side.CLIENT)
    public RenderChannelValve getRenderer() {
        return new RenderChannelValve(this);
    }

    @Override
    public Class<? extends ItemBlockCustomWood> getItemBlockClass() {
        return ItemBlockValve.class;
    }

    public void registerRecipes() {
        CustomWoodRecipeHelper.registerCustomWoodRecipe((Block)AgriBlocks.getInstance().CHANNEL_VALVE, 1, false, new ItemStack(Items.field_151042_j, 1), new ItemStack(Blocks.field_150442_at, 1), AgriBlocks.getInstance().CHANNEL);
    }

    public static class ItemBlockValve
    extends ItemBlockCustomWood {
        public ItemBlockValve(Block block) {
            super(block);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
            super.func_77624_a(stack, player, list, flag);
            list.add(AgriCore.getTranslator().translate("agricraft_tooltip.valve"));
        }
    }
}

