/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.compat.computer.methods;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.compat.computer.methods.IMethod;
import com.infinityraider.agricraft.compat.computer.methods.MethodException;
import com.infinityraider.agricraft.compat.computer.methods.MethodParameter;
import com.infinityraider.agricraft.compat.computer.methods.MethodUtilities;
import com.infinityraider.agricraft.compat.computer.tiles.TileEntityPeripheral;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MethodBase
implements IMethod {
    public final String name;
    public final String signature;
    public final boolean requiresJournal;
    public final boolean appliesToPeripheral;
    public final boolean appliesToCrop;

    public MethodBase(String name) {
        this(name, false, true, false);
    }

    public MethodBase(String name, boolean j, boolean p, boolean c) {
        this.name = name;
        this.requiresJournal = j;
        this.appliesToPeripheral = p;
        this.appliesToCrop = c;
        this.signature = MethodUtilities.genSignature(name, this.getParameters());
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getSignature() {
        return this.signature;
    }

    @Override
    public final String getDescription() {
        return AgriCore.getTranslator().translate("agricraft_description.method." + this.getName());
    }

    @Override
    public final Object[] call(TileEntityPeripheral peripheral, World world, BlockPos pos, ItemStack journal, Object ... args) throws MethodException {
        if (this.appliesToPeripheral) {
            if (args != null && args.length != 0) {
                throw new MethodException(this, "Too many arguments!");
            }
            return this.callMethodForPeripheral(peripheral, journal);
        }
        if (this.appliesToCrop) {
            EnumFacing dir = EnumFacing.valueOf((String)args[0].toString());
            if (dir == null) {
                throw new MethodException(this, "Invalid Direction!");
            }
            TileEntity tile = world.func_175625_s(pos.func_177982_a(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()));
            if (tile == null) {
                throw new MethodException(this, "Missing Crop!");
            }
            if (!(tile instanceof TileEntityCrop)) {
                throw new MethodException(this, "Not a crop!");
            }
            return this.callMethodForCrop((TileEntityCrop)tile, journal);
        }
        throw new MethodException(this, "Command does not apply to anything!");
    }

    private Object[] callMethodForPeripheral(TileEntityPeripheral peripheral, ItemStack journal) throws MethodException {
        if (this.requiresJournal) {
            if (journal == null || journal.func_77973_b() == null) {
                throw new MethodException(this, "Journal is missing");
            }
            ItemStack specimen = peripheral.getSpecimen();
            ItemStack seed = specimen.func_77946_l();
            if (!MethodUtilities.isSeedDiscovered(journal, seed)) {
                throw new MethodException(this, "No information about this seed in the journal");
            }
        }
        return this.onMethodCalled(peripheral);
    }

    private Object[] callMethodForCrop(TileEntityCrop crop, ItemStack journal) throws MethodException {
        boolean hasJournal;
        boolean bl = hasJournal = journal != null;
        if (this.requiresJournal) {
            if (!hasJournal) {
                throw new MethodException(this, "Journal is missing");
            }
            if (!crop.hasSeed()) {
                throw new MethodException(this, "There is no plant in the crop to analyze!");
            }
            if (crop.hasSeed() && !MethodUtilities.isSeedDiscovered(journal, crop.getSeed().toStack())) {
                throw new MethodException(this, "No information about this seed in the journal");
            }
        }
        return this.onMethodCalled(crop);
    }

    protected abstract List<MethodParameter> getParameters();

    protected abstract Object[] onMethodCalled(TileEntityCrop var1) throws MethodException;

    protected abstract Object[] onMethodCalled(TileEntityPeripheral var1) throws MethodException;
}

