/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.compat.jei;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.compat.jei.mutation.MutationRecipeCategory;
import com.infinityraider.agricraft.compat.jei.mutation.MutationRecipeHandler;
import com.infinityraider.agricraft.compat.jei.produce.ProduceRecipeCategory;
import com.infinityraider.agricraft.compat.jei.produce.ProduceRecipeHandler;
import com.infinityraider.agricraft.init.AgriItems;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class AgriCraftJEIPlugin
implements IModPlugin {
    public static final String CATEGORY_MUTATION = "agricraft.mutation";
    public static final String CATEGORY_PRODUCE = "agricraft.produce";
    private static IJeiRuntime jeiRuntime;

    public void register(@Nonnull IModRegistry registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new MutationRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ProduceRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new MutationRecipeHandler(), new ProduceRecipeHandler()});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)AgriItems.getInstance().CROPS), new String[]{CATEGORY_MUTATION, CATEGORY_PRODUCE});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntimeInstance) {
        jeiRuntime = jeiRuntimeInstance;
        AgriApi.getPlantRegistry().all().forEach(arg_0 -> ((IRecipeRegistry)jeiRuntime.getRecipeRegistry()).addRecipe(arg_0));
        AgriApi.getMutationRegistry().all().forEach(arg_0 -> ((IRecipeRegistry)jeiRuntime.getRecipeRegistry()).addRecipe(arg_0));
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)AgriItems.getInstance().AGRI_SEED, stack -> {
            Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(stack);
            return seed.map(s -> s.getPlant().getId()).orElse("generic");
        });
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }
}

