/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.mutation.IAgriCrossStrategy;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpreadStrategy
implements IAgriCrossStrategy {
    @Override
    public double getRollChance() {
        return Math.abs(1.0f - AgriCraftConfig.mutationChance);
    }

    @Override
    public Optional<AgriSeed> executeStrategy(IAgriCrop crop, Random rand) {
        int index;
        AgriSeed seed;
        List matureNeighbours = WorldHelper.getTileNeighbors((World)crop.getCropWorld(), (BlockPos)crop.getCropPos(), IAgriCrop.class);
        matureNeighbours.removeIf(c -> !c.isMature());
        if (!matureNeighbours.isEmpty() && (seed = ((IAgriCrop)matureNeighbours.get(index = rand.nextInt(matureNeighbours.size()))).getSeed()) != null && rand.nextDouble() < seed.getPlant().getSpreadChance()) {
            return AgriApi.getStatCalculatorRegistry().valueOf(seed.getPlant()).map(calc -> calc.calculateSpreadStats(seed.getPlant(), matureNeighbours)).map(stat -> new AgriSeed(seed.getPlant(), (IAgriStat)stat));
        }
        return Optional.empty();
    }
}

