/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation.statcalculator;

import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatCalculator;
import com.infinityraider.agricraft.farming.PlantStats;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import java.util.Collection;
import java.util.Objects;

public abstract class StatCalculatorBase
implements IAgriStatCalculator,
IAgriAdapter<IAgriStatCalculator> {
    @Override
    public IAgriStat calculateSpreadStats(IAgriPlant child, Collection<IAgriCrop> parents) {
        Objects.requireNonNull(child, "The child plant to calculate the stats for must not be null!");
        Objects.requireNonNull(parents, "The set of parents to calculate the child's stats from must not be null!");
        int invalidParents = 0;
        int validParents = 0;
        int growth = 0;
        int gain = 0;
        int strength = 0;
        for (IAgriCrop parent : parents) {
            AgriSeed parentSeed;
            if (parent == null || (parentSeed = parent.getSeed()) == null) continue;
            if (!parent.isMature()) {
                ++invalidParents;
                continue;
            }
            if (!Objects.equals(child, parentSeed.getPlant())) {
                ++invalidParents;
                continue;
            }
            ++validParents;
            growth += parentSeed.getStat().getGrowth();
            gain += parentSeed.getStat().getGain();
            strength += parentSeed.getStat().getStrength();
        }
        int meanDivisor = StatCalculatorBase.calculateStatMeanDivisor(validParents, invalidParents);
        return new PlantStats(this.calculateStat(growth /= meanDivisor, validParents, 1), this.calculateStat(gain /= meanDivisor, validParents, 1), this.calculateStat(strength /= meanDivisor, validParents, 1));
    }

    @Override
    public IAgriStat calculateMutationStats(IAgriMutation mutation, Collection<IAgriCrop> parents) {
        Objects.requireNonNull(mutation, "The mutation to calculate the stats for must not be null!");
        Objects.requireNonNull(parents, "The set of parents to calculate the mutation result stats from must not be null!");
        int invalidParents = 0;
        int validParents = 0;
        int growth = 0;
        int gain = 0;
        int strength = 0;
        for (IAgriCrop parent : parents) {
            AgriSeed parentSeed;
            if (parent == null || (parentSeed = parent.getSeed()) == null) continue;
            if (!parent.isMature()) {
                ++invalidParents;
                continue;
            }
            if (!mutation.hasParent(parentSeed.getPlant())) {
                ++invalidParents;
                continue;
            }
            ++validParents;
            growth += parentSeed.getStat().getGrowth();
            gain += parentSeed.getStat().getGain();
            strength += parentSeed.getStat().getStrength();
        }
        int meanDivisor = StatCalculatorBase.calculateStatMeanDivisor(validParents, invalidParents);
        return new PlantStats(this.calculateStat(growth /= meanDivisor, validParents, AgriCraftConfig.cropStatDivisor), this.calculateStat(gain /= meanDivisor, validParents, AgriCraftConfig.cropStatDivisor), this.calculateStat(strength /= meanDivisor, validParents, AgriCraftConfig.cropStatDivisor));
    }

    protected abstract int calculateStat(int var1, int var2, int var3);

    public static final int calculateStatMeanDivisor(int validParents, int invalidParents) {
        int meanDivisor = validParents;
        if (AgriCraftConfig.otherCropsAffectStatsNegatively) {
            meanDivisor += validParents;
        }
        if (meanDivisor < 1) {
            meanDivisor = 1;
        }
        return meanDivisor;
    }
}

