/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui.storage;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.container.ContainerSeedStorageBase;
import com.infinityraider.agricraft.gui.AgriGuiWrapper;
import com.infinityraider.agricraft.gui.ComponentGui;
import com.infinityraider.agricraft.gui.component.BasicComponents;
import com.infinityraider.agricraft.gui.component.GuiComponent;
import com.infinityraider.agricraft.gui.component.GuiComponentBuilder;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageControllable;
import com.infinityraider.agricraft.tiles.storage.SeedStorageSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiSeedStorageBase
extends ComponentGui<ContainerSeedStorageBase> {
    public static final int BUTTON_WIDTH = 60;
    public static final int BUTTON_HEIGHT = 12;
    protected AgriSeed activeSeed;
    private int scrollPositionVertical;
    private int scrollPositionHorizontal;
    private int sortStatId = -1;
    private final int maxVertSlots;
    private final int maxHorSlots;
    private final int sortButtonX;
    private final int sortButtonY;
    private final int setActiveSeedButtonOffset_X;
    private final int setActiveSeedButtonOffset_Y;
    private final int seedSlotButtonOffset_X;
    private final int seedSlotButtonOffset_Y;
    protected final List<GuiComponent<StorageElement>> activeSeeds = new ArrayList<GuiComponent<StorageElement>>();
    protected List<GuiComponent<ItemStack>> setActiveSeedButtons;
    private String sortMethod = "growth";

    public GuiSeedStorageBase(ContainerSeedStorageBase container, int maxVertSlots, int maxHorSlots, int sortButtonX, int sortButtonY, int setActiveSeedButtonsX, int setActiveSeedButtonsY, int seedSlotsX, int seedSlotsY) {
        super(237, 131, container);
        this.maxVertSlots = maxVertSlots;
        this.maxHorSlots = maxHorSlots;
        this.sortButtonX = sortButtonX;
        this.sortButtonY = sortButtonY;
        this.setActiveSeedButtonOffset_X = setActiveSeedButtonsX;
        this.setActiveSeedButtonOffset_Y = setActiveSeedButtonsY;
        this.seedSlotButtonOffset_X = seedSlotsX;
        this.seedSlotButtonOffset_Y = seedSlotsY;
    }

    protected boolean hasActiveSeed() {
        return this.activeSeed != null;
    }

    protected void getActiveSeed() {
        TileEntity tile = ((ContainerSeedStorageBase)((Object)this.getContainer())).getTile();
        if (tile instanceof ISeedStorageControllable) {
            this.activeSeed = ((ISeedStorageControllable)tile).getLockedSeed().orElse(null);
        }
    }

    @Override
    protected void onComponentGuiInit(AgriGuiWrapper wrapper) {
        this.clearComponents();
        this.addComponent(BasicComponents.getButtonComponent("agricraft_tooltip.growth", this.sortButtonX, this.calcSortY(0), 60, 12, (c, p) -> this.setSortMethod("growth")));
        this.addComponent(BasicComponents.getButtonComponent("agricraft_tooltip.gain", this.sortButtonX, this.calcSortY(1), 60, 12, (c, p) -> this.setSortMethod("gain")));
        this.addComponent(BasicComponents.getButtonComponent("agricraft_tooltip.strength", this.sortButtonX, this.calcSortY(2), 60, 12, (c, p) -> this.setSortMethod("strength")));
        this.addComponent(BasicComponents.getButtonComponent("<<", this.sortButtonX, this.sortButtonY + 39, 14, 12, (c, p) -> this.scrollHorizontal(-this.getMaxHorizontalScroll())));
        this.addComponent(BasicComponents.getButtonComponent("<", this.sortButtonX + 15, this.sortButtonY + 39, 14, 12, (c, p) -> this.scrollHorizontal(-1)));
        this.addComponent(BasicComponents.getButtonComponent(">", this.sortButtonX + 1 + 30, this.sortButtonY + 39, 14, 12, (c, p) -> this.scrollHorizontal(1)));
        this.addComponent(BasicComponents.getButtonComponent(">>", this.sortButtonX + 1 + 45, this.sortButtonY + 39, 14, 12, (c, p) -> this.scrollHorizontal(this.getMaxHorizontalScroll())));
    }

    private int calcSortY(int index) {
        return this.sortButtonY + index + index * 12;
    }

    private boolean setSortMethod(String method) {
        this.sortMethod = method;
        return true;
    }

    private void initSetActiveSeedButtons() {
        if (this.setActiveSeedButtonOffset_X < 0 || this.setActiveSeedButtonOffset_Y < 0) {
            return;
        }
        this.setActiveSeedButtons = new ArrayList<GuiComponent<ItemStack>>();
        List<ItemStack> list = ((ContainerSeedStorageBase)((Object)this.getContainer())).getSeedEntries();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                int xOffset = this.setActiveSeedButtonOffset_X + 16 * i % 64;
                int yOffset = this.setActiveSeedButtonOffset_Y + 16 * (i / 4);
                this.setActiveSeedButtons.add(new GuiComponentBuilder<ItemStack>(list.get(i), xOffset, yOffset, 16, 16).build());
            }
        }
    }

    private void initSeedSlots() {
        this.getActiveSeed();
        this.activeSeeds.clear();
        List<SeedStorageSlot> list = ((ContainerSeedStorageBase)((Object)this.getContainer())).getSeedSlots(this.activeSeed);
        if (list != null) {
            this.sortByStat(list, this.sortMethod);
            for (int i = this.scrollPositionHorizontal; i < Math.min(list.size(), this.scrollPositionHorizontal + this.maxHorSlots); ++i) {
                SeedStorageSlot slot = list.get(i);
                StorageElement storageElement = new StorageElement(slot.getId(), slot.count, slot.getSeed());
            }
        }
    }

    private void sortByStat(List<SeedStorageSlot> list, String stat) {
        if (stat != null && this.activeSeed != null) {
            Collections.sort(list, new SeedStorageSlot.SlotComparator(stat));
        }
    }

    private boolean scrollVertical(int amount) {
        int newPos = this.scrollPositionVertical + amount;
        newPos = newPos < 0 ? 0 : newPos;
        int maxScrollY = this.getMaxVerticalScroll();
        this.scrollPositionVertical = newPos = newPos > maxScrollY ? maxScrollY : newPos;
        return true;
    }

    private int getMaxVerticalScroll() {
        int nrSeedButtons = this.setActiveSeedButtons.size();
        int nrRows = (nrSeedButtons % 4 > 0 ? 1 : 0) + nrSeedButtons / 4;
        if (nrRows <= this.maxVertSlots) {
            return 0;
        }
        return nrRows - this.maxVertSlots;
    }

    private boolean scrollHorizontal(int amount) {
        if (this.hasActiveSeed()) {
            int newPos = this.scrollPositionHorizontal + amount;
            newPos = newPos < 0 ? 0 : newPos;
            int maxScrollX = this.getMaxHorizontalScroll();
            this.scrollPositionHorizontal = newPos = newPos > maxScrollX ? maxScrollX : newPos;
        }
        return true;
    }

    private int getMaxHorizontalScroll() {
        int nrSlots = this.seedSlotAmount();
        if (nrSlots <= this.maxHorSlots) {
            return 0;
        }
        return nrSlots - this.maxHorSlots;
    }

    private int seedSlotAmount() {
        return this.hasActiveSeed() ? ((ContainerSeedStorageBase)((Object)this.getContainer())).getSeedSlots(this.activeSeed).size() : 0;
    }

    protected void drawActiveEntries(AgriGuiWrapper wrapper, ResourceLocation texture, int xOffset, int yOffset) {
        if (!this.hasActiveSeed()) {
            return;
        }
        int textureSize = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.activeSeeds.size(); ++i) {
            GuiComponent<StorageElement> component = this.activeSeeds.get(i);
            if (component == null || component.getComponent() == null) continue;
            StorageElement element = component.getComponent();
            ItemStack stack = this.activeSeed.toStack(element.amount);
            NBTTagCompound tag = new NBTTagCompound();
            element.getStat().writeToNBT(tag);
            stack.func_77982_d(tag);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            GL11.glDisable((int)2896);
            short growth = element.getStat().getGrowth();
            short gain = element.getStat().getGain();
            short strength = element.getStat().getStrength();
            wrapper.func_73729_b(xOffset + i * 16 + 1, yOffset - growth, 0, textureSize - growth, 3, growth);
            wrapper.func_73729_b(xOffset + i * 16 + 6, yOffset - gain, 0, textureSize - gain, 3, gain);
            wrapper.func_73729_b(xOffset + i * 16 + 11, yOffset - strength, 0, textureSize - strength, 3, strength);
            GL11.glEnable((int)2896);
        }
    }

    protected void drawScrollBarHorizontal(AgriGuiWrapper wrapper, ResourceLocation texture) {
        int nrSlots = this.seedSlotAmount();
        int total = 224;
        int slotWidth = 16;
        int fullLength = nrSlots <= this.maxHorSlots ? total : slotWidth * nrSlots;
        float unit = (float)slotWidth / (float)fullLength * (float)total;
        int offset = (int)((float)this.scrollPositionHorizontal * unit);
        int length = (int)((float)this.maxHorSlots * unit);
        length = length <= 2 ? 0 : (length >= total ? total - 2 : length);
        offset = offset == 0 ? offset : offset - 1;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int xOffset = 6;
        int yOffset = 39;
        wrapper.func_73729_b(6 + offset, 39, 0, 135, 1, 5);
        wrapper.func_73729_b(6 + offset + 1, 39, 1, 135, length, 4);
        wrapper.func_73729_b(6 + offset + 1 + length, 39, total - 1, 135, 1, 5);
        GL11.glEnable((int)2896);
    }

    protected void setActiveSeed(ItemStack stack) {
        AgriApi.getSeedRegistry().valueOf(stack).ifPresent(this::setActiveSeed);
    }

    protected void setActiveSeed(AgriSeed seed) {
        this.activeSeed = seed;
    }

    protected static class StorageElement {
        private final int id;
        private final int amount;
        private final AgriSeed seed;

        public StorageElement(int id, int amount, @Nonnull AgriSeed seed) {
            this.id = id;
            this.amount = amount;
            this.seed = seed;
        }

        public int id() {
            return this.id;
        }

        public int amount() {
            return this.amount;
        }

        public AgriSeed getSeed() {
            return this.seed;
        }

        public IAgriStat getStat() {
            return this.seed.getStat();
        }

        public IAgriPlant getPlant() {
            return this.seed.getPlant();
        }
    }
}

