/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.reference.AgriNuggetType;
import com.infinityraider.agricraft.utility.OreDictHelper;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ItemNugget
extends ItemBase
implements IAutoRenderedItem,
IRecipeRegister {
    public ItemNugget() {
        super("agri_nugget");
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> varients) {
        for (AgriNuggetType type : AgriNuggetType.values()) {
            ItemStack stack = new ItemStack(item, 1, type.ordinal());
            OreDictionary.registerOre((String)type.nugget, (ItemStack)stack);
            varients.add(stack);
        }
    }

    public boolean func_77614_k() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        return AgriNuggetType.getNugget(stack.func_77960_j()).getUnlocalizedName();
    }

    public String getModelId(ItemStack stack) {
        return AgriNuggetType.getNugget((int)stack.func_77960_j()).nugget;
    }

    public String getBaseTexture(ItemStack stack) {
        return AgriNuggetType.getNugget((int)stack.func_77960_j()).texture;
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(AgriNuggetType.values().length);
        for (AgriNuggetType type : AgriNuggetType.values()) {
            textures.add(new ResourceLocation(type.texture));
        }
        return textures;
    }

    public void registerRecipes() {
        for (AgriNuggetType type : AgriNuggetType.values()) {
            ItemStack nugget = new ItemStack((Item)this, 9, type.ordinal());
            ItemStack ingot = OreDictHelper.getIngot(type.ingot);
            AgriCore.getLogger("agricraft").debug("Registering Nugget: {0} For: {1}", type.nugget, type.ingot);
            if (ingot == null) continue;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingot, new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), type.nugget}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(nugget, new Object[]{type.ingot}));
        }
    }
}

