/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.api.v1.irrigation.IrrigationConnection;
import com.infinityraider.agricraft.api.v1.irrigation.IrrigationConnectionType;
import com.infinityraider.agricraft.blocks.irrigation.AbstractBlockWaterChannel;
import com.infinityraider.agricraft.renderers.blocks.RenderBlockCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.render.RenderUtilBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderChannel<B extends AbstractBlockWaterChannel<T>, T extends TileEntityChannel>
extends RenderBlockCustomWood<B, T> {
    public static AtomicInteger renderCallCounter = new AtomicInteger(0);

    public RenderChannel(B block, T channel) {
        super(block, channel, true, true, true);
    }

    protected void renderWoodChannel(ITessellator tessellator, IBlockState state, TextureAtlasSprite icon) {
        IrrigationConnection metas = new IrrigationConnection();
        metas.read(state);
        this.renderBottom(tessellator, icon);
        this.renderSide(tessellator, state, EnumFacing.NORTH, metas.get(EnumFacing.NORTH), icon);
        this.renderSide(tessellator, state, EnumFacing.EAST, metas.get(EnumFacing.EAST), icon);
        this.renderSide(tessellator, state, EnumFacing.SOUTH, metas.get(EnumFacing.SOUTH), icon);
        this.renderSide(tessellator, state, EnumFacing.WEST, metas.get(EnumFacing.WEST), icon);
    }

    protected void renderBottom(ITessellator tessellator, TextureAtlasSprite matIcon) {
        tessellator.drawScaledPrism(4.0f, 4.0f, 4.0f, 12.0f, 5.0f, 12.0f, matIcon);
        tessellator.drawScaledPrism(4.0f, 5.0f, 4.0f, 5.0f, 12.0f, 5.0f, matIcon);
        tessellator.drawScaledPrism(11.0f, 5.0f, 4.0f, 12.0f, 12.0f, 5.0f, matIcon);
        tessellator.drawScaledPrism(4.0f, 5.0f, 11.0f, 5.0f, 12.0f, 12.0f, matIcon);
        tessellator.drawScaledPrism(11.0f, 5.0f, 11.0f, 12.0f, 12.0f, 12.0f, matIcon);
    }

    protected void renderSide(ITessellator tessellator, IBlockState state, EnumFacing dir, IrrigationConnectionType type, TextureAtlasSprite matIcon) {
        switch (dir) {
            case EAST: {
                if (type.isPrimary()) {
                    tessellator.drawScaledPrism(12.0f, 4.0f, 4.0f, 16.0f, 5.0f, 12.0f, matIcon);
                    tessellator.drawScaledPrism(12.0f, 5.0f, 4.0f, 16.0f, 12.0f, 5.0f, matIcon);
                    tessellator.drawScaledPrism(12.0f, 5.0f, 11.0f, 16.0f, 12.0f, 12.0f, matIcon);
                    break;
                }
                tessellator.drawScaledPrism(11.0f, 5.0f, 5.0f, 12.0f, 12.0f, 11.0f, matIcon);
                break;
            }
            case WEST: {
                if (type.isPrimary()) {
                    tessellator.drawScaledPrism(0.0f, 4.0f, 4.0f, 4.0f, 5.0f, 12.0f, matIcon);
                    tessellator.drawScaledPrism(0.0f, 5.0f, 4.0f, 4.0f, 12.0f, 5.0f, matIcon);
                    tessellator.drawScaledPrism(0.0f, 5.0f, 11.0f, 4.0f, 12.0f, 12.0f, matIcon);
                    break;
                }
                tessellator.drawScaledPrism(4.0f, 5.0f, 5.0f, 5.0f, 12.0f, 11.0f, matIcon);
                break;
            }
            case NORTH: {
                if (type.isPrimary()) {
                    tessellator.drawScaledPrism(4.0f, 4.0f, 0.0f, 12.0f, 5.0f, 4.0f, matIcon);
                    tessellator.drawScaledPrism(4.0f, 5.0f, 0.0f, 5.0f, 12.0f, 4.0f, matIcon);
                    tessellator.drawScaledPrism(11.0f, 5.0f, 0.0f, 12.0f, 12.0f, 4.0f, matIcon);
                    break;
                }
                tessellator.drawScaledPrism(5.0f, 5.0f, 4.0f, 11.0f, 12.0f, 5.0f, matIcon);
                break;
            }
            case SOUTH: {
                if (type.isPrimary()) {
                    tessellator.drawScaledPrism(4.0f, 4.0f, 12.0f, 12.0f, 5.0f, 16.0f, matIcon);
                    tessellator.drawScaledPrism(4.0f, 5.0f, 12.0f, 5.0f, 12.0f, 16.0f, matIcon);
                    tessellator.drawScaledPrism(11.0f, 5.0f, 12.0f, 12.0f, 12.0f, 16.0f, matIcon);
                    break;
                }
                tessellator.drawScaledPrism(5.0f, 5.0f, 11.0f, 11.0f, 12.0f, 12.0f, matIcon);
            }
        }
    }

    protected void drawWater(ITessellator tessellator, T channel, TextureAtlasSprite icon) {
        if (((TileEntityChannel)channel).getFluidAmount(0) < 0) {
            return;
        }
        renderCallCounter.incrementAndGet();
        int l = RenderUtilBase.getMixedBrightness((World)channel.func_145831_w(), (BlockPos)channel.func_174877_v(), (Block)Blocks.field_150355_j);
        tessellator.setBrightness(l);
        tessellator.setAlpha(0.39f);
        float y = (float)((TileEntityChannel)channel).getFluidHeight() - 0.001f;
        tessellator.drawScaledFaceDouble(5.0f, 5.0f, 11.0f, 11.0f, EnumFacing.UP, icon, y);
        if (((TileEntityChannel)channel).hasNeighbor(EnumFacing.NORTH)) {
            tessellator.drawScaledFaceDouble(5.0f, 0.0f, 11.0f, 5.0f, EnumFacing.UP, icon, y);
        }
        if (((TileEntityChannel)channel).hasNeighbor(EnumFacing.EAST)) {
            tessellator.drawScaledFaceDouble(11.0f, 5.0f, 16.0f, 11.0f, EnumFacing.UP, icon, y);
        }
        if (((TileEntityChannel)channel).hasNeighbor(EnumFacing.SOUTH)) {
            tessellator.drawScaledFaceDouble(5.0f, 11.0f, 11.0f, 16.0f, EnumFacing.UP, icon, y);
        }
        if (((TileEntityChannel)channel).hasNeighbor(EnumFacing.WEST)) {
            tessellator.drawScaledFaceDouble(0.0f, 5.0f, 5.0f, 11.0f, EnumFacing.UP, icon, y);
        }
    }

    @Override
    protected void renderWorldBlockWoodDynamic(ITessellator tess, World world, BlockPos pos, B block, T tile, TextureAtlasSprite icon) {
        this.drawWater(tess, tile, BaseIcons.WATER_STILL.getIcon());
    }

    @Override
    protected void renderWorldBlockWoodStatic(ITessellator tess, IExtendedBlockState state, B block, EnumFacing side, TextureAtlasSprite icon) {
        this.renderWoodChannel(tess, (IBlockState)state, icon);
    }

    @Override
    protected void renderInventoryBlockWood(ITessellator tessellator, World world, IBlockState state, B block, T channel, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type, TextureAtlasSprite icon) {
        this.renderBottom(tessellator, icon);
        this.renderSide(tessellator, state, EnumFacing.NORTH, IrrigationConnectionType.NONE, icon);
        this.renderSide(tessellator, state, EnumFacing.EAST, IrrigationConnectionType.NONE, icon);
        this.renderSide(tessellator, state, EnumFacing.SOUTH, IrrigationConnectionType.NONE, icon);
        this.renderSide(tessellator, state, EnumFacing.WEST, IrrigationConnectionType.NONE, icon);
    }

    public boolean applyAmbientOcclusion() {
        return false;
    }
}

