/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.irrigation.BlockSprinkler;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.tiles.irrigation.TileEntitySprinkler;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.render.block.RenderBlockWithTileBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSprinkler
extends RenderBlockWithTileBase<BlockSprinkler, TileEntitySprinkler> {
    private static final float MIN_Y = 8.0f;
    private static final float MAX_Y = 12.0f;
    private static final float MIN_C = 7.0f;
    private static final float MAX_C = 9.0f;
    private static final float BLADE_W = 1.0f;
    private static final float BLADE_L = 3.0f;
    private static final float BMX_Y = 9.0f;
    private static final float BMX_A = 4.0f;
    private static final float BMX_B = 12.0f;

    public RenderSprinkler(BlockSprinkler block) {
        super((BlockBase)block, (TileEntityBase)new TileEntitySprinkler(), true, true, true);
    }

    public void renderInventoryBlock(ITessellator tessellator, World world, IBlockState state, BlockSprinkler block, TileEntitySprinkler tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
        tessellator.drawScaledPrism(4.0f, 8.0f, 4.0f, 12.0f, 16.0f, 12.0f, BaseIcons.OAK_PLANKS.getIcon());
        TextureAtlasSprite coreIcon = BaseIcons.IRON_BLOCK.getIcon();
        tessellator.drawScaledPrism(7.0f, 0.0f, 7.0f, 9.0f, 8.0f, 9.0f, coreIcon);
        tessellator.drawScaledPrism(4.0f, 0.0f, 7.0f, 12.0f, 1.0f, 9.0f, coreIcon);
        tessellator.drawScaledPrism(7.0f, 0.0f, 4.0f, 9.0f, 1.0f, 12.0f, coreIcon);
    }

    public List<ResourceLocation> getAllTextures() {
        return Collections.emptyList();
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, BlockSprinkler block, EnumFacing side) {
        tessellator.translate(0.0f, 0.25f, 0.0f);
        CustomWoodType type = state instanceof IExtendedBlockState ? (CustomWoodType)((IExtendedBlockState)state).getValue(AgriProperties.CUSTOM_WOOD_TYPE) : CustomWoodTypeRegistry.DEFAULT;
        tessellator.drawScaledPrism(4.0f, 8.0f, 4.0f, 12.0f, 16.0f, 12.0f, type.getIcon());
    }

    public void renderWorldBlockDynamic(ITessellator tess, World world, BlockPos pos, double x, double y, double z, BlockSprinkler block, TileEntitySprinkler te, float partialTick, int destroyStage) {
        tess.pushMatrix();
        tess.translate(0.5f, 0.0f, 0.5f);
        tess.rotate(te.getAngle(), 0.0f, 1.0f, 0.0f);
        tess.translate(-0.5f, 0.0f, -0.5f);
        TextureAtlasSprite icon = BaseIcons.IRON_BLOCK.getIcon();
        tess.drawScaledPrism(7.0f, 8.0f, 7.0f, 9.0f, 12.0f, 9.0f, icon);
        tess.drawScaledPrism(4.0f, 8.0f, 7.0f, 12.0f, 9.0f, 9.0f, icon);
        tess.drawScaledPrism(7.0f, 8.0f, 4.0f, 9.0f, 9.0f, 12.0f, icon);
        tess.popMatrix();
    }

    public TextureAtlasSprite getIcon() {
        return ((TileEntitySprinkler)this.getTileEntity()).getChannelIcon();
    }

    public boolean applyAmbientOcclusion() {
        return false;
    }
}

