/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.utility.IconHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum BaseIcons {
    WATER_STILL("minecraft:blocks/water_still"),
    WATER_FLOW("minecraft:blocks/water_flow"),
    OAK_PLANKS("minecraft:blocks/planks_oak"),
    IRON_BLOCK("minecraft:blocks/iron_block"),
    DEBUG("agricraft:items/debugger"),
    DIRT("minecraft:blocks/dirt"),
    VINE("minecraft:blocks/vine");

    @Nonnull
    public final String location;
    @Nonnull
    private TextureAtlasSprite cachedIcon;
    @Nonnull
    private boolean isLoaded;

    private BaseIcons(String location) {
        this.location = location;
        this.cachedIcon = IconHelper.getDefaultIcon();
        this.isLoaded = false;
    }

    public TextureAtlasSprite getIcon() {
        if (!this.isLoaded) {
            AgriCore.getLogger("agricraft").debug("Load Icon " + this.name() + " STARTED...", new Object[0]);
            this.isLoaded = this.attemptLoad();
            AgriCore.getLogger("agricraft").debug("Load Icon " + this.name() + ": " + (this.isLoaded ? "SUCEEDED!" : "FAILED!"), new Object[0]);
        }
        return this.cachedIcon;
    }

    private boolean attemptLoad() {
        this.cachedIcon = IconHelper.getIcon(this.location);
        return this.cachedIcon != IconHelper.getDefaultIcon();
    }
}

