/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.util.TypeHelper;
import com.google.common.math.IntMath;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import com.infinityraider.agricraft.utility.NBTHelper;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class StackHelper {
    public static boolean isValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null;
    }

    public static boolean isValid(ItemStack stack, Class<?> itemClass) {
        return stack != null && TypeHelper.isType(stack.func_77973_b(), itemClass);
    }

    public static boolean isValid(ItemStack stack, Class<?> ... itemClasses) {
        return StackHelper.isValid(stack) && TypeHelper.isAllTypes(stack.func_77973_b(), (Class[])itemClasses);
    }

    public static boolean areEqual(@Nullable ItemStack a, @Nullable ItemStack b) {
        return ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemsEqual(@Nullable ItemStack a, @Nullable ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemsEqualIgnoringMeta(@Nullable ItemStack a, @Nullable ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b);
    }

    public static boolean hasTag(@Nullable ItemStack stack) {
        return stack != null && stack.func_77978_p() != null;
    }

    public static boolean hasKey(@Nullable ItemStack stack, String ... keys) {
        return stack != null && NBTHelper.hasKey(stack.func_77978_p(), keys);
    }

    @Nonnull
    public static NBTTagCompound getTag(@Nonnull ItemStack stack) {
        Objects.requireNonNull(stack, "The stack to fetch the NBTTagCompound from must not be null!");
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static int getSize(@Nullable ItemStack stack) {
        return stack == null ? 0 : stack.field_77994_a;
    }

    @Nonnull
    public static List<ItemStack> fitToMaxSize(@Nullable ItemStack stack) {
        ItemStack partial;
        if (stack == null) {
            return Collections.EMPTY_LIST;
        }
        if (stack.field_77994_a < 1) {
            return Collections.EMPTY_LIST;
        }
        int stackSize = stack.field_77994_a;
        int maxSize = stack.func_77976_d();
        if (stack.field_77994_a <= maxSize) {
            Arrays.asList(stack);
        }
        int totalStackCount = IntMath.divide((int)stackSize, (int)maxSize, (RoundingMode)RoundingMode.UP);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(totalStackCount);
        while (stackSize > maxSize) {
            partial = stack.func_77946_l();
            partial.field_77994_a = maxSize;
            stackSize -= maxSize;
            stacks.add(partial);
        }
        if (stackSize > 0) {
            partial = stack.func_77946_l();
            partial.field_77994_a = stackSize;
            stacks.add(partial);
        }
        return stacks;
    }

    @Nonnull
    public static MethodResult decreaseStackSize(@Nullable EntityPlayer player, @Nullable ItemStack stack, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Cannot decrease ItemStack size by a negative amount! " + amount + " is not valid!");
        }
        if (stack == null) {
            return MethodResult.FAIL;
        }
        if (player != null && player.func_184812_l_()) {
            return MethodResult.PASS;
        }
        if (stack.field_77994_a - amount < 0) {
            return MethodResult.FAIL;
        }
        stack.field_77994_a -= amount;
        return MethodResult.PASS;
    }
}

