/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import team.chisel.ctm.CTM;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.model.ModelCTM;
import team.chisel.ctm.client.model.parsing.ModelLoaderCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;

public enum TextureMetadataHandler {
    INSTANCE;

    private static final Class<?> multipartModelClass;
    private static final Class<?> vanillaModelWrapperClass;
    private static final Field multipartPartModels;
    private static final Field modelWrapperModel;

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (Minecraft.func_71410_x().func_147117_R() != null) {
            Map mapRegisteredSprites = (Map)ReflectionHelper.getPrivateValue(TextureMap.class, (Object)Minecraft.func_71410_x().func_147117_R(), (String[])new String[]{"field_110574_e", "mapRegisteredSprites"});
            ProgressManager.ProgressBar prog = ProgressManager.push((String)"Loading Chisel metadata", (int)mapRegisteredSprites.size());
            for (String res : ImmutableMap.copyOf((Map)mapRegisteredSprites).keySet()) {
                try {
                    ResourceLocation proxysprite;
                    IMetadataSectionCTM proxymeta;
                    ResourceLocation rel = new ResourceLocation(res);
                    prog.step(rel.toString());
                    IMetadataSectionCTM metadata = ResourceUtil.getMetadata(rel = new ResourceLocation(rel.func_110624_b(), "textures/" + rel.func_110623_a() + ".png"));
                    if (metadata == null) continue;
                    if (metadata.getProxy() != null && (proxymeta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(proxysprite = new ResourceLocation(metadata.getProxy())))) != null) {
                        event.getMap().func_174942_a(proxysprite);
                        for (ResourceLocation r : proxymeta.getAdditionalTextures()) {
                            event.getMap().func_174942_a(r);
                        }
                    }
                    for (ResourceLocation r : metadata.getAdditionalTextures()) {
                        event.getMap().func_174942_a(r);
                    }
                }
                catch (FileNotFoundException rel) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)prog);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        Map stateModels = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String[])new String[]{"stateModels"});
        block6: for (ModelResourceLocation mrl : event.getModelRegistry().func_148742_b()) {
            IModel model = (IModel)stateModels.get(mrl);
            if (model == null || model instanceof IModelCTM || ModelLoaderCTM.parsedLocations.contains(mrl)) continue;
            Set<Object> textures = Sets.newHashSet((Iterable)model.getTextures());
            if (vanillaModelWrapperClass.isAssignableFrom(model.getClass())) {
                ModelBlock parent = ((ModelBlock)TextureMetadataHandler.modelWrapperModel.get((Object)model)).field_178315_d;
                while (parent != null) {
                    textures.addAll(parent.field_178318_c.values().stream().filter(s -> !s.startsWith("#")).map(ResourceLocation::new).collect(Collectors.toSet()));
                    parent = parent.field_178315_d;
                }
            }
            if (multipartModelClass.isAssignableFrom(model.getClass())) {
                Map partModels = (Map)multipartPartModels.get(model);
                textures = partModels.values().stream().map(m -> m.getTextures()).flatMap(Collection::stream).collect(Collectors.toSet());
            }
            for (ResourceLocation tex : textures) {
                IMetadataSectionCTM meta = null;
                try {
                    meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(tex));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (meta == null) continue;
                try {
                    event.getModelRegistry().func_82595_a((Object)mrl, (Object)this.wrap(model, (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl)));
                }
                catch (IOException e) {
                    CTM.logger.error("Could not wrap model " + mrl + ". Aborting...", (Throwable)e);
                }
                continue block6;
            }
        }
    }

    @Nonnull
    private IBakedModel wrap(IModel model, IBakedModel object) throws IOException {
        ModelCTM modelchisel = new ModelCTM(null, model, (Int2ObjectMap<JsonElement>)Int2ObjectMaps.emptyMap());
        modelchisel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, (Function<ResourceLocation, TextureAtlasSprite>)((Function)rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString())));
        return new ModelBakedCTM(modelchisel, object);
    }

    static {
        try {
            multipartModelClass = Class.forName("net.minecraftforge.client.model.ModelLoader$MultipartModel");
            multipartPartModels = multipartModelClass.getDeclaredField("partModels");
            multipartPartModels.setAccessible(true);
            vanillaModelWrapperClass = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
            modelWrapperModel = vanillaModelWrapperClass.getDeclaredField("model");
            modelWrapperModel.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

