/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.client;

import com.feed_the_beast.ftbl.api.client.Color4I;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;

public final class CubeRenderer {
    private static final float[] normalsX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
    private static final float[] normalsY = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] normalsZ = new float[]{0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f};
    private final boolean hasTexture;
    private final boolean hasNormals;
    public final Color4I color;
    private final VertexFormat format;
    private boolean beginAndEnd = true;
    private Tessellator tessellator;
    private VertexBuffer buffer;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private double minU;
    private double minV;
    private double maxU;
    private double maxV;

    public CubeRenderer(boolean tex, boolean norm) {
        this.hasTexture = tex;
        this.hasNormals = norm;
        this.color = new Color4I();
        this.format = new VertexFormat();
        this.format.func_181721_a(DefaultVertexFormats.field_181713_m);
        this.format.func_181721_a(DefaultVertexFormats.field_181714_n);
        if (this.hasTexture) {
            this.format.func_181721_a(DefaultVertexFormats.field_181715_o);
        }
        if (this.hasNormals) {
            this.format.func_181721_a(DefaultVertexFormats.field_181717_q);
            this.format.func_181721_a(DefaultVertexFormats.field_181718_r);
        }
    }

    public CubeRenderer setTessellator(Tessellator t, VertexBuffer vb) {
        this.tessellator = t;
        this.buffer = vb;
        return this;
    }

    public CubeRenderer setTessellator(Tessellator t) {
        return this.setTessellator(t, t.func_178180_c());
    }

    public void setSize(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.minX = x0;
        this.minY = y0;
        this.minZ = z0;
        this.maxX = x1;
        this.maxY = y1;
        this.maxZ = z1;
    }

    public void setSize(AxisAlignedBB aabb) {
        this.setSize(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public void setSizeWHD(double x, double y, double z, double w, double h, double d) {
        this.setSize(x, y, z, x + w, y + h, z + d);
    }

    public void offset(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public void offset(Vec3i pos) {
        this.offset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void setUV(double u0, double v0, double u1, double v1) {
        this.minU = u0;
        this.minV = v0;
        this.maxU = u1;
        this.maxV = v1;
    }

    public void renderAll() {
        this.begin();
        this.beginAndEnd = false;
        this.renderDown();
        this.renderUp();
        this.renderSouth();
        this.renderNorth();
        this.renderWest();
        this.renderEast();
        this.beginAndEnd = true;
        this.end();
    }

    public void renderSides() {
        this.begin();
        this.beginAndEnd = false;
        this.renderSouth();
        this.renderNorth();
        this.renderWest();
        this.renderEast();
        this.beginAndEnd = true;
        this.end();
    }

    public void renderFace(EnumFacing f) {
        switch (f) {
            case DOWN: {
                this.renderDown();
                break;
            }
            case UP: {
                this.renderUp();
                break;
            }
            case SOUTH: {
                this.renderSouth();
                break;
            }
            case NORTH: {
                this.renderNorth();
                break;
            }
            case WEST: {
                this.renderWest();
                break;
            }
            case EAST: {
                this.renderEast();
            }
        }
    }

    public void begin() {
        if (this.beginAndEnd) {
            this.buffer.func_181668_a(7, this.format);
        }
    }

    public void end() {
        if (this.beginAndEnd) {
            this.tessellator.func_78381_a();
        }
    }

    private void vertex(int i, double x, double y, double z, double u, double v) {
        this.buffer.func_181662_b(x, y, z);
        this.buffer.func_181669_b(this.color.red, this.color.green, this.color.blue, this.color.alpha);
        if (this.hasTexture) {
            this.buffer.func_187315_a(u, v);
        }
        if (this.hasNormals) {
            this.buffer.func_181663_c(normalsX[i], normalsY[i], normalsZ[i]);
        }
        this.buffer.func_181675_d();
    }

    public void renderDown() {
        this.begin();
        this.vertex(0, this.minX, this.minY, this.minZ, this.minU, this.minV);
        this.vertex(0, this.maxX, this.minY, this.minZ, this.maxU, this.minV);
        this.vertex(0, this.maxX, this.minY, this.maxZ, this.maxU, this.maxV);
        this.vertex(0, this.minX, this.minY, this.maxZ, this.minU, this.maxV);
        this.end();
    }

    public void renderUp() {
        this.begin();
        this.vertex(1, this.minX, this.maxY, this.minZ, this.minU, this.minV);
        this.vertex(1, this.minX, this.maxY, this.maxZ, this.minU, this.maxV);
        this.vertex(1, this.maxX, this.maxY, this.maxZ, this.maxU, this.maxV);
        this.vertex(1, this.maxX, this.maxY, this.minZ, this.maxU, this.minV);
        this.end();
    }

    public void renderSouth() {
        this.begin();
        this.vertex(2, this.minX, this.minY, this.maxZ, this.minU, this.maxV);
        this.vertex(2, this.maxX, this.minY, this.maxZ, this.maxU, this.maxV);
        this.vertex(2, this.maxX, this.maxY, this.maxZ, this.maxU, this.minV);
        this.vertex(2, this.minX, this.maxY, this.maxZ, this.minU, this.minV);
        this.end();
    }

    public void renderNorth() {
        this.begin();
        this.vertex(3, this.minX, this.minY, this.minZ, this.maxU, this.maxV);
        this.vertex(3, this.minX, this.maxY, this.minZ, this.maxU, this.minV);
        this.vertex(3, this.maxX, this.maxY, this.minZ, this.minU, this.minV);
        this.vertex(3, this.maxX, this.minY, this.minZ, this.minU, this.maxV);
        this.end();
    }

    public void renderWest() {
        this.begin();
        this.vertex(4, this.minX, this.minY, this.minZ, this.minU, this.maxV);
        this.vertex(4, this.minX, this.minY, this.maxZ, this.maxU, this.maxV);
        this.vertex(4, this.minX, this.maxY, this.maxZ, this.maxU, this.minV);
        this.vertex(4, this.minX, this.maxY, this.minZ, this.minU, this.minV);
        this.end();
    }

    public void renderEast() {
        this.begin();
        this.vertex(5, this.maxX, this.minY, this.minZ, this.maxU, this.maxV);
        this.vertex(5, this.maxX, this.maxY, this.minZ, this.maxU, this.minV);
        this.vertex(5, this.maxX, this.maxY, this.maxZ, this.minU, this.minV);
        this.vertex(5, this.maxX, this.minY, this.maxZ, this.minU, this.maxV);
        this.end();
    }
}

