/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.ITeamMessage;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.api_impl.ForgeTeam;
import com.feed_the_beast.ftbl.client.teamsgui.MyTeamPlayerData;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MyTeamData
extends FinalIDObject {
    public static int unreadMessages = 0;
    public static long lastMessageTime = 0L;
    public String displayName;
    public String description;
    public MyTeamPlayerData owner;
    public List<MyTeamPlayerData> players;
    public List<ITeamMessage> chatHistory;
    public MyTeamPlayerData me;
    private int myPlayerIndex;

    public MyTeamData(ByteBuf io) {
        super(ByteBufUtils.readUTF8String((ByteBuf)io));
        this.displayName = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.description = ByteBufUtils.readUTF8String((ByteBuf)io);
        int s = io.readInt();
        this.players = new ArrayList<MyTeamPlayerData>();
        while (--s >= 0) {
            MyTeamPlayerData pi = new MyTeamPlayerData(io);
            this.players.add(pi);
            if (this.owner != null || pi.status != EnumTeamStatus.OWNER) continue;
            this.owner = pi;
        }
        this.me = this.players.get(io.readInt());
        s = io.readInt();
        this.chatHistory = new ArrayList<ITeamMessage>(s);
        while (--s >= 0) {
            this.chatHistory.add(new ForgeTeam.Message(io));
        }
    }

    public MyTeamData(IUniverse universe, IForgeTeam team, IForgePlayer player) {
        super(team.func_176610_l());
        this.displayName = team.getColor().getTextFormatting() + team.getTitle();
        this.description = team.getDesc();
        this.players = new ArrayList<MyTeamPlayerData>();
        this.chatHistory = team.getMessages();
        int i = 0;
        for (IForgePlayer iForgePlayer : universe.getPlayers()) {
            EnumTeamStatus s = team.getHighestStatus(iForgePlayer);
            if (s.isNone() || s == EnumTeamStatus.INVITED && !team.freeToJoin()) continue;
            MyTeamPlayerData pi = new MyTeamPlayerData(iForgePlayer, s);
            this.players.add(pi);
            if (this.owner == null && s == EnumTeamStatus.OWNER) {
                this.owner = pi;
            }
            if (iForgePlayer.equalsPlayer(player)) {
                this.me = pi;
                this.myPlayerIndex = i;
            }
            ++i;
        }
    }

    public void write(ByteBuf io) {
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.func_176610_l());
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.displayName);
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.description);
        io.writeInt(this.players.size());
        for (MyTeamPlayerData p : this.players) {
            p.write(io);
        }
        io.writeInt(this.myPlayerIndex);
        io.writeInt(this.chatHistory.size());
        for (ITeamMessage msg : this.chatHistory) {
            ForgeTeam.Message.write(io, msg);
        }
    }
}

