/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.NotificationId;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.DrawableItem;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class Notification
implements INotification {
    private NotificationId id;
    private Color4I color;
    private int timer;
    private List<ITextComponent> text;
    private IDrawableObject icon;

    public Notification(NotificationId i) {
        this.id = i;
        this.text = new ArrayList<ITextComponent>();
        this.setDefaults();
    }

    public Notification setError(ITextComponent title) {
        ITextComponent t = title.func_150259_f();
        t.func_150256_b().func_150238_a(TextFormatting.WHITE);
        this.addText(t);
        this.timer = 3000;
        this.color = Color4I.LIGHT_RED;
        this.icon = new DrawableItem(new ItemStack(Blocks.field_180401_cv));
        return this;
    }

    public void setDefaults() {
        this.text.clear();
        this.timer = 3000;
        this.color = Color4I.GRAY;
        this.icon = ImageProvider.NULL;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof INotification && ((INotification)o).getId().equals(this.getId());
    }

    public String toString() {
        return this.getId() + ", text:" + this.getText() + ", col:" + this.color + ", timer:" + this.getTimer() + ", icon:" + this.getIcon().getJson();
    }

    public Notification addText(@Nullable ITextComponent t) {
        if (t != null) {
            this.text.add(t);
        }
        return this;
    }

    @Override
    public NotificationId getId() {
        return this.id;
    }

    @Override
    public List<ITextComponent> getText() {
        return this.text;
    }

    @Override
    public IDrawableObject getIcon() {
        return this.icon;
    }

    public Notification setIcon(IDrawableObject i) {
        this.icon = i;
        return this;
    }

    @Override
    public int getTimer() {
        return this.timer;
    }

    public Notification setTimer(int t) {
        this.timer = t;
        return this;
    }

    @Override
    public Color4I getColor() {
        return this.color;
    }

    public Notification setColor(Color4I c) {
        this.color = c;
        return this;
    }

    public static Notification copy(INotification n) {
        Notification n1 = new Notification(n.getId());
        n1.getText().addAll(n.getText());
        n1.setColor(new Color4I(true, n.getColor()));
        n1.setTimer(n.getTimer());
        n1.setIcon(n.getIcon());
        return n1;
    }
}

