/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.event.ClickEvent;

public class SidebarButton
extends FinalIDObject {
    public IDrawableObject icon = ImageProvider.NULL;
    public IConfigValue config = null;
    public final Map<String, Boolean> dependencies = new HashMap<String, Boolean>();
    public final List<String> requiredServerMods = new ArrayList<String>();
    private ClickEvent clickEvent;
    public boolean requiresOp;
    public boolean devOnly;
    public boolean hideWithNEI;
    public boolean loadingScreen;

    public SidebarButton(ResourceLocation id) {
        super(id.toString().replace(':', '.'));
    }

    public SidebarButton(ResourceLocation id, JsonObject o) {
        this(id);
        if (o.has("icon")) {
            this.icon = ImageProvider.get(o.get("icon"));
        }
        if (this.icon == ImageProvider.NULL) {
            this.icon = GuiIcons.ACCEPT_GRAY;
        }
        if (o.has("dependencies")) {
            this.setDependencies(o.get("dependencies").getAsString());
        }
        if (o.has("click")) {
            this.clickEvent = JsonUtils.deserializeClickEvent(o.get("click"));
        }
        if (o.has("config")) {
            this.config = new PropertyBool(o.get("config").getAsBoolean());
        }
        this.requiresOp = o.has("requires_op") && o.get("requires_op").getAsBoolean();
        this.devOnly = o.has("dev_only") && o.get("dev_only").getAsBoolean();
        this.hideWithNEI = o.has("hide_with_nei") && o.get("hide_with_nei").getAsBoolean();
        this.loadingScreen = o.has("loading_screen") && o.get("loading_screen").getAsBoolean();
    }

    public void setDependencies(String deps) {
        this.dependencies.clear();
        if (!deps.isEmpty()) {
            block8: for (String s : deps.split(";")) {
                int index = s.indexOf(58);
                if (index == -1) continue;
                switch (s.substring(0, index)) {
                    case "before": {
                        this.dependencies.put(s.substring(index + 1, s.length()), true);
                        continue block8;
                    }
                    case "after": {
                        this.dependencies.put(s.substring(index + 1, s.length()), false);
                    }
                }
            }
        }
    }

    public void onClicked(IMouseButton button) {
        if (this.clickEvent != null) {
            if (this.loadingScreen) {
                new GuiLoading().openGui();
            }
            GuiHelper.onClickEvent(this.clickEvent);
        }
    }

    public boolean isVisible() {
        return !(this.hideWithNEI && LMUtils.isNEILoaded() || this.requiresOp && !FTBLibIntegrationInternal.API.getClientData().isClientOP() || !this.requiredServerMods.isEmpty() && FTBLibIntegrationInternal.API.getClientData().optionalServerMods().containsAll(this.requiredServerMods));
    }
}

