/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IImageProvider;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ColoredObject;
import com.feed_the_beast.ftbl.lib.client.DrawableItem;
import com.feed_the_beast.ftbl.lib.client.DrawableObjectList;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageProvider
implements IImageProvider {
    public static final ImageProvider NULL = new ImageProvider(new ResourceLocation("textures/misc/unknown_pack.png")){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(int x, int y, int w, int h, Color4I col) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(Widget widget, Color4I col) {
        }
    };
    private final ResourceLocation texture;
    private final String url;

    public static IDrawableObject get(JsonElement json) {
        if (json.isJsonNull()) {
            return NULL;
        }
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("id")) {
                switch (o.get("id").getAsString()) {
                    case "colored": {
                        Color4I col = new Color4I(true, ColorUtils.deserialize(o.get("color")));
                        return new ColoredObject(ImageProvider.get((JsonElement)o.get("parent").getAsJsonObject()), o.has("color_alpha") ? new Color4I(true, col, o.get("color_alpha").getAsInt()) : col);
                    }
                }
            }
        } else if (json.isJsonArray()) {
            ArrayList<IDrawableObject> list = new ArrayList<IDrawableObject>();
            for (JsonElement e : json.getAsJsonArray()) {
                list.add(ImageProvider.get(e));
            }
            return list.isEmpty() ? NULL : new DrawableObjectList(list);
        }
        return ImageProvider.get(json.getAsString());
    }

    public static IDrawableObject get(String id) {
        return id.isEmpty() ? NULL : ImageProvider.get(new ResourceLocation(id));
    }

    public static IDrawableObject get(ResourceLocation id) {
        if (id.func_110624_b().equals("item")) {
            ItemStack stack = ItemStackSerializer.parseItem(id.func_110623_a());
            if (!ItemStackTools.isEmpty((ItemStack)stack)) {
                return new DrawableItem(stack);
            }
        } else if (id.func_110623_a().isEmpty()) {
            return NULL;
        }
        return new ImageProvider(id);
    }

    public ImageProvider(ResourceLocation tex) {
        this.texture = tex;
        this.url = this.texture.func_110624_b().equals("http") || this.texture.func_110624_b().equals("https") ? this.texture.toString() : "";
    }

    @Override
    public boolean isURL() {
        return this.url.length() > 0;
    }

    @Override
    public final ResourceLocation getImage() {
        return this.texture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ITextureObject bindTexture() {
        if (this.isURL()) {
            ITextureObject obj = FTBLibClient.getDownloadImage(this.texture, this.url, NULL.getImage(), null);
            GlStateManager.func_179144_i((int)obj.func_110552_b());
            return obj;
        }
        return FTBLibClient.bindTexture(this.texture);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IImageProvider) {
            IImageProvider img = (IImageProvider)o;
            return this.texture.equals((Object)img.getImage()) && this.getMinU() == img.getMinU() && this.getMinV() == img.getMinV() && this.getMaxU() == img.getMaxU() && this.getMaxV() == img.getMaxV();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, this.getMinU(), this.getMinV(), this.getMaxU(), this.getMaxV()});
    }

    public String toString() {
        return Double.toString(this.getMinU()) + ',' + this.getMinV() + ',' + this.getMaxU() + ',' + this.getMaxV();
    }
}

