/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ConfigTree
implements IConfigTree {
    private static final int HAS_DISPLAY_NAME = 1;
    private static final int HAS_INFO = 2;
    private static final int HAS_GROUP = 4;
    private final Map<IConfigKey, IConfigValue> tree;

    public ConfigTree(boolean linked) {
        this.tree = linked ? new LinkedHashMap() : new HashMap();
    }

    public ConfigTree() {
        this(false);
    }

    @Override
    public final Map<IConfigKey, IConfigValue> getTree() {
        return this.tree;
    }

    @Override
    public IConfigTree copy() {
        ConfigTree t = new ConfigTree();
        this.getTree().forEach((key, value) -> t.add((IConfigKey)key, value.copy()));
        return t;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort(this.tree.size());
        this.tree.forEach((key, value) -> {
            String info;
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)key.func_176610_l());
            data.writeInt(key.getFlags());
            IConfigValue defValue = key.getDefValue();
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)defValue.func_176610_l());
            defValue.writeData(data);
            int extraFlags = 0;
            String displayName = key.getNameLangKey();
            if (!displayName.isEmpty()) {
                extraFlags |= 1;
            }
            if (!(info = key.getInfoLangKey()).isEmpty()) {
                extraFlags |= 2;
            }
            if (!key.getGroup().isEmpty()) {
                extraFlags |= 4;
            }
            data.writeByte(extraFlags);
            if (!displayName.isEmpty()) {
                ByteBufUtils.writeUTF8String((ByteBuf)data, (String)displayName);
            }
            if (!info.isEmpty()) {
                ByteBufUtils.writeUTF8String((ByteBuf)data, (String)info);
            }
            if (!key.getGroup().isEmpty()) {
                ByteBufUtils.writeUTF8String((ByteBuf)data, (String)key.getGroup());
            }
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)value.func_176610_l());
            value.writeData(data);
        });
    }

    @Override
    public void readData(ByteBuf data) {
        int s = data.readUnsignedShort();
        this.tree.clear();
        while (--s >= 0) {
            String id = ByteBufUtils.readUTF8String((ByteBuf)data);
            int flags = data.readInt();
            IConfigValue value = FTBLibIntegrationInternal.API.getConfigValueFromID(ByteBufUtils.readUTF8String((ByteBuf)data));
            value.readData(data);
            ConfigKey key = new ConfigKey(id, value);
            key.setFlags(flags);
            short extraFlags = data.readUnsignedByte();
            if (Bits.getFlag(extraFlags, 1)) {
                key.setNameLangKey(ByteBufUtils.readUTF8String((ByteBuf)data));
            }
            if (Bits.getFlag(extraFlags, 2)) {
                key.setInfoLangKey(ByteBufUtils.readUTF8String((ByteBuf)data));
            }
            if (Bits.getFlag(extraFlags, 4)) {
                key.setGroup(ByteBufUtils.readUTF8String((ByteBuf)data));
            }
            value = FTBLibIntegrationInternal.API.getConfigValueFromID(ByteBufUtils.readUTF8String((ByteBuf)data));
            value.readData(data);
            this.tree.put(key, value);
        }
    }

    public void func_152753_a(JsonElement json) {
        JsonObject o = json.getAsJsonObject();
        this.getTree().forEach((key, value) -> {
            JsonElement e;
            if (!key.getFlag(1) && (e = o.get(key.func_176610_l())) != null) {
                value.func_152753_a(e);
            }
        });
    }

    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        this.tree.forEach((key, value) -> {
            if (!key.getFlag(1)) {
                o.add(key.func_176610_l(), value.func_151003_a());
            }
        });
        return o;
    }
}

