/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.PropertyInt;
import io.netty.buffer.ByteBuf;

public class PropertyShort
extends PropertyInt {
    public static final String ID = "short";
    private boolean unsigned = false;

    public PropertyShort() {
    }

    public PropertyShort(int v) {
        super(v);
    }

    public PropertyShort(int v, int min, int max) {
        super(v, min, max);
    }

    public PropertyShort(int v, int min, int max, boolean u) {
        this(v, min, max);
        this.unsigned = u;
    }

    public PropertyShort setUnsigned() {
        this.unsigned = true;
        return this;
    }

    @Override
    public void setInt(int v) {
        super.setInt(this.unsigned ? (short)(v & 0xFFFF) : (short)v);
    }

    @Override
    public String func_176610_l() {
        return ID;
    }

    @Override
    public IConfigValue copy() {
        return new PropertyShort(this.getInt(), this.getMin(), this.getMax(), this.unsigned);
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeBoolean(this.unsigned);
        data.writeShort(this.getInt());
        data.writeShort(this.getMin());
        data.writeShort(this.getMax());
    }

    @Override
    public void readData(ByteBuf data) {
        this.unsigned = data.readBoolean();
        this.setInt(this.unsigned ? data.readUnsignedShort() : (int)data.readShort());
        this.setMin(this.unsigned ? data.readUnsignedShort() : (int)data.readShort());
        this.setMax(this.unsigned ? data.readUnsignedShort() : (int)data.readShort());
    }
}

