/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.config.PropertyBase;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PropertyString
extends PropertyBase {
    public static final String ID = "string";
    public static final Color4I COLOR = new Color4I(false, -21943);
    private String value;
    private int charLimit;

    public PropertyString() {
        this("");
    }

    public PropertyString(String v) {
        this(v, 0);
    }

    public PropertyString(String v, int limit) {
        this.value = v;
        this.charLimit = limit;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public String getString() {
        return this.value;
    }

    public void setString(String v) {
        this.value = v;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getString();
    }

    @Override
    public boolean getBoolean() {
        return this.getString().equals("true");
    }

    @Override
    public int getInt() {
        return Integer.parseInt(this.getString());
    }

    @Override
    public IConfigValue copy() {
        return new PropertyString(this.getString(), this.charLimit);
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        this.setString(text);
        return true;
    }

    @Override
    public void addInfo(IConfigKey key, List<String> list) {
        super.addInfo(key, list);
        if (this.charLimit > 0) {
            list.add(TextFormatting.AQUA + "Char Limit: " + this.charLimit);
        }
    }

    public void func_152753_a(JsonElement json) {
        this.setString(json.getAsString());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive(this.getString());
    }

    @Override
    public void writeData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.getString());
        data.writeShort(this.charLimit);
    }

    @Override
    public void readData(ByteBuf data) {
        this.setString(ByteBufUtils.readUTF8String((ByteBuf)data));
        this.charLimit = data.readUnsignedShort();
    }

    public boolean isEmpty() {
        return this.getString().isEmpty();
    }
}

