/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.CachedVertexData;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiConfigs;
import com.feed_the_beast.ftbl.lib.gui.misc.ThreadReloadChunkSelector;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.ChunkPos;

public class GuiChunkSelectorBase
extends GuiBase {
    private static final CachedVertexData GRID = new CachedVertexData(1, DefaultVertexFormats.field_181706_f);
    public final int startX;
    public final int startZ;
    private final MapButton[] mapButtons;
    private final Panel panelButtons;
    public int currentSelectionMode = -1;

    public GuiChunkSelectorBase() {
        super(240, 240);
        this.startX = MathUtils.chunk(this.mc.field_71439_g.field_70165_t) - 7;
        this.startZ = MathUtils.chunk(this.mc.field_71439_g.field_70161_v) - 7;
        this.panelButtons = new Panel(0, 0, 16, 0){

            @Override
            public void addWidgets() {
                GuiChunkSelectorBase.this.addCornerButtons(GuiChunkSelectorBase.this.panelButtons);
            }
        };
        this.mapButtons = new MapButton[225];
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i] = new MapButton(0, 0, i);
        }
    }

    @Override
    public void addWidgets() {
        for (MapButton b : this.mapButtons) {
            this.add(b);
        }
        this.add(this.panelButtons);
        this.panelButtons.posX = this.getScreen().func_78326_a() - 16 - this.posX;
        this.panelButtons.posY = -this.posY;
        this.panelButtons.setHeight(this.panelButtons.widgets.size() * 16);
    }

    @Override
    public void drawBackground() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawBlankRect(this.posX - 2, this.posY - 2, this.width + 4, this.height + 4, Color4I.BLACK);
        ThreadReloadChunkSelector.updateTexture();
        GlStateManager.func_179144_i((int)ThreadReloadChunkSelector.getTextureID());
        GuiHelper.drawTexturedRect(this.posX, this.posY, 240, 240, Color4I.WHITE, 0.0, 0.0, 0.9375, 0.9375);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        this.mc.func_110434_K().func_110577_a(GuiConfigs.TEX_CHUNK_CLAIMING);
        for (MapButton mapButton : this.mapButtons) {
            mapButton.renderWidget(this);
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_178969_c((double)this.mapButtons[0].getAX(), (double)this.mapButtons[0].getAY(), 0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawArea(tessellator, buffer);
        GRID.draw(tessellator, buffer);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
        int cx = MathUtils.chunk(this.mc.field_71439_g.field_70165_t);
        int cy = MathUtils.chunk(this.mc.field_71439_g.field_70161_v);
        if (cx >= this.startX && cy >= this.startZ && cx < this.startX + 15 && cy < this.startZ + 15) {
            double x = (double)(cx - this.startX) * 16.0 + MathUtils.wrap(this.mc.field_71439_g.field_70165_t, 16.0);
            double y = (double)(cy - this.startZ) * 16.0 + MathUtils.wrap(this.mc.field_71439_g.field_70161_v, 16.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)this.posX + x), (double)((double)this.posY + y), (double)0.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(this.mc.field_71439_g.field_70177_z + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(GuiConfigs.TEX_ENTITY);
            GuiHelper.drawTexturedRect(-8, -8, 16, 16, Color4I.WHITE_A33, 0.0, 0.0, 1.0, 1.0);
            GlStateManager.func_179121_F();
            FTBLibClient.localPlayerHead.draw(-2, -2, 4, 4, Color4I.NONE);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void mouseReleased(GuiBase gui) {
        super.mouseReleased(gui);
        if (this.currentSelectionMode != -1) {
            ArrayList<ChunkPos> c = new ArrayList<ChunkPos>();
            for (MapButton b : this.mapButtons) {
                if (!b.isSelected) continue;
                c.add(b.chunkPos);
                b.isSelected = false;
            }
            this.onChunksSelected(c);
            this.currentSelectionMode = -1;
        }
    }

    @Override
    public void drawForeground() {
        this.addCornerText(TEMP_TEXT_LIST);
        for (int i = 0; i < TEMP_TEXT_LIST.size(); ++i) {
            String s = (String)TEMP_TEXT_LIST.get(TEMP_TEXT_LIST.size() - 1 - i);
            this.getFont().func_175063_a(s, (float)(this.getScreen().func_78326_a() - this.getFont().func_78256_a(s) - 4), (float)(this.getScreen().func_78328_b() - 12 - i * 12), -1);
        }
        TEMP_TEXT_LIST.clear();
        super.drawForeground();
    }

    public int getSelectionMode(IMouseButton button) {
        return -1;
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
    }

    public void drawArea(Tessellator tessellator, VertexBuffer buffer) {
    }

    public void addCornerButtons(Panel panel) {
    }

    public void addCornerText(List<String> list) {
    }

    public void addButtonText(MapButton button, List<String> list) {
    }

    static {
        GuiChunkSelectorBase.GRID.color.set(128, 128, 128, 50);
        for (int x = 0; x <= 15; ++x) {
            GRID.pos(x * 16, 0.0);
            GRID.pos(x * 16, 240.0, 0.0);
        }
        for (int y = 0; y <= 15; ++y) {
            GRID.pos(0.0, y * 16, 0.0);
            GRID.pos(240.0, y * 16, 0.0);
        }
    }

    public class MapButton
    extends Button {
        public final ChunkPos chunkPos;
        public final int index;
        private boolean isSelected;

        private MapButton(int x, int y, int i) {
            super(x, y, 16, 16);
            this.isSelected = false;
            this.posX += i % 15 * this.width;
            this.posY += i / 15 * this.height;
            this.chunkPos = new ChunkPos(GuiChunkSelectorBase.this.startX + i % 15, GuiChunkSelectorBase.this.startZ + i / 15);
            this.index = i;
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            GuiHelper.playClickSound();
            GuiChunkSelectorBase.this.currentSelectionMode = GuiChunkSelectorBase.this.getSelectionMode(button);
            if (GuiChunkSelectorBase.this.currentSelectionMode == -1) {
                GuiChunkSelectorBase.this.onChunksSelected(Collections.singleton(this.chunkPos));
            }
        }

        @Override
        public void addMouseOverText(GuiBase gui, List<String> list) {
            GuiChunkSelectorBase.this.addButtonText(this, list);
        }

        @Override
        public void renderWidget(GuiBase gui) {
            int ax = this.getAX();
            int ay = this.getAY();
            if (!this.isSelected && GuiChunkSelectorBase.this.currentSelectionMode != -1 && GuiChunkSelectorBase.this.isMouseOver(this)) {
                this.isSelected = true;
            }
            if (this.isSelected || gui.isMouseOver(this)) {
                GuiHelper.drawBlankRect(ax, ay, 16, 16, Color4I.WHITE_A33);
            }
        }
    }
}

