/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiGuide;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;

public class ButtonGuidePage
extends Button {
    public final GuidePage page;
    public String hover;
    private boolean mouseOver;
    private boolean prevMouseOver = false;
    private boolean isSmall;

    public ButtonGuidePage(GuiGuide g, GuidePage p, boolean small) {
        super(0, 0, 0, 0);
        this.page = p;
        this.isSmall = small;
        this.setHeight(p.getIcon() == ImageProvider.NULL || this.isSmall ? 13 : 18);
        this.updateTitle(g);
    }

    @Override
    public void onClicked(GuiBase gui, IMouseButton button) {
        GuiHelper.playClickSound();
        ((GuiGuide)gui).setSelectedPage(this.page);
    }

    public void updateTitle(GuiGuide gui) {
        ITextComponent titleC = this.page.getDisplayName().func_150259_f();
        if (gui.getSelectedPage() == this.page) {
            titleC.func_150256_b().func_150227_a(Boolean.valueOf(true));
        }
        if (this.mouseOver) {
            titleC.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        this.setTitle(titleC.func_150254_d());
        this.hover = null;
        this.setWidth(gui.getFont().func_78256_a(this.getTitle(gui)) + (this.page.getIcon() != ImageProvider.NULL ? this.height : 0));
        if (this.width > this.getParentPanel().width) {
            this.hover = this.page.getDisplayName().func_150254_d();
        }
    }

    @Override
    public void addMouseOverText(GuiBase gui, List<String> list) {
        if (this.hover != null) {
            list.add(this.hover);
        }
    }

    @Override
    public void renderWidget(GuiBase gui) {
        this.mouseOver = gui.isMouseOver(this);
        if (this.mouseOver) {
            this.getParentPanel().setOffset(false);
            this.mouseOver = gui.isMouseOver(this.getParentPanel());
            this.getParentPanel().setOffset(true);
        }
        if (this.prevMouseOver != this.mouseOver) {
            this.updateTitle((GuiGuide)gui);
            this.prevMouseOver = this.mouseOver;
        }
        int ay = this.getAY();
        int ax = this.getAX();
        if (this.page.getIcon() != ImageProvider.NULL) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.page.getIcon().draw(ax + 1, ay + 1, this.isSmall ? 8 : 16, this.isSmall ? 8 : 16, Color4I.NONE);
            gui.drawString(this.getTitle(gui), ax + (this.isSmall ? 13 : 19), ay + (this.isSmall ? 1 : 6));
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.drawString(this.getTitle(gui), ax + 1, ay + 1);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

