/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.lib.client.DrawableObjectList;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.DrawableObjectListButton;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.guide.EmptyGuidePageLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import net.minecraft.util.math.MathHelper;

public class DrawableObjectListLine
extends EmptyGuidePageLine {
    private final DrawableObjectList list;
    private final int cols;

    public DrawableObjectListLine(DrawableObjectList l, int columns) {
        this.list = l;
        this.cols = MathHelper.func_76125_a((int)columns, (int)0, (int)16);
    }

    public DrawableObjectListLine(JsonElement json) {
        block3: {
            block2: {
                this.list = new DrawableObjectList(Collections.emptyList());
                if (!json.isJsonObject()) break block2;
                JsonObject o = json.getAsJsonObject();
                this.cols = MathHelper.func_76125_a((int)(o.has("columns") ? o.get("columns").getAsInt() : 8), (int)0, (int)16);
                if (!o.has("objects")) break block3;
                for (JsonElement e : o.get("objects").getAsJsonArray()) {
                    this.list.list.add(ImageProvider.get(e));
                }
                break block3;
            }
            this.cols = 8;
            for (JsonElement e : json.getAsJsonArray()) {
                this.list.list.add(ImageProvider.get(e));
            }
        }
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("item_list"));
        o.add("columns", (JsonElement)new JsonPrimitive((Number)this.cols));
        JsonArray a = new JsonArray();
        for (IDrawableObject item : this.list.list) {
            a.add(item.getJson());
        }
        o.add("objects", (JsonElement)a);
        return o;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new DrawableObjectListButton(0, 0, this.list, this.cols);
    }

    @Override
    public IGuideTextLine copy(GuidePage page) {
        return new DrawableObjectListLine(this.list, this.cols);
    }

    @Override
    public boolean isEmpty() {
        return this.list.list.isEmpty();
    }
}

