/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.guide.EmptyGuidePageLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class GuideHrLine
extends EmptyGuidePageLine {
    public final int height;
    public final Color4I color;

    public GuideHrLine(int h, Color4I c) {
        this.height = h;
        this.color = c;
    }

    public GuideHrLine(JsonElement e) {
        JsonObject o = e.getAsJsonObject();
        this.height = o.has("height") ? Math.max(1, o.get("height").getAsInt()) : 1;
        this.color = o.has("color") ? new Color4I(true, 0xFF000000 | ColorUtils.deserialize(o.get("color"))) : Color4I.NONE;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new WidgetGuideHr(parent);
    }

    @Override
    public IGuideTextLine copy(GuidePage page) {
        return new GuideHrLine(this.height, this.color);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("hr"));
        o.add("height", (JsonElement)new JsonPrimitive((Number)this.height));
        o.add("color", this.color.toJson());
        return o;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private class WidgetGuideHr
    extends Widget {
        private WidgetGuideHr(Panel parent) {
            super(0, 1, parent.width, GuideHrLine.this.height + 2);
        }

        @Override
        public void renderWidget(GuiBase gui) {
            GuiHelper.drawBlankRect(this.getAX(), this.getAY() + 1, this.width, GuideHrLine.this.height, GuideHrLine.this.color.hasColor() ? GuideHrLine.this.color : gui.getContentColor());
        }
    }
}

