/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.gui.IImageProvider;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.guide.EmptyGuidePageLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.lwjgl.opengl.GL11;

public class GuideImageLine
extends EmptyGuidePageLine {
    public IImageProvider imageProvider = ImageProvider.NULL;
    public int imageWidth;
    public int imageHeight;
    public double imageScale = 1.0;
    public ClickEvent clickEvent;
    public List<String> hover;

    public GuideImageLine() {
    }

    public GuideImageLine(JsonElement e) {
        this.imageProvider = ImageProvider.NULL;
        this.imageHeight = 0;
        this.imageWidth = 0;
        this.imageScale = 1.0;
        this.hover = null;
        JsonObject o = e.getAsJsonObject();
        if (!o.has("image")) {
            return;
        }
        this.imageProvider = new ImageProvider(new ResourceLocation(o.get("image").getAsString()));
        if (o.has("scale")) {
            this.imageScale = o.get("scale").getAsDouble();
        } else if (o.has("size")) {
            this.imageWidth = this.imageHeight = o.get("size").getAsInt();
        } else {
            if (o.has("width")) {
                this.imageWidth = o.get("width").getAsInt();
            }
            if (o.has("height")) {
                this.imageHeight = o.get("height").getAsInt();
            }
        }
        if (o.has("click")) {
            this.clickEvent = JsonUtils.deserializeClickEvent(o.get("click"));
        }
        if (o.has("hover")) {
            this.hover = new ArrayList<String>();
            for (JsonElement e1 : o.get("hover").getAsJsonArray()) {
                ITextComponent c = JsonUtils.deserializeTextComponent(e1);
                this.hover.add(c == null ? "" : c.func_150254_d());
            }
        }
        if (this.hover == null || this.hover.isEmpty()) {
            this.hover = Collections.emptyList();
        }
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new ButtonInfoImage(parent);
    }

    @Override
    public IGuideTextLine copy(GuidePage page) {
        GuideImageLine line = new GuideImageLine();
        line.imageProvider = this.imageProvider;
        line.imageWidth = this.imageWidth;
        line.imageHeight = this.imageHeight;
        line.imageScale = this.imageScale;
        line.clickEvent = this.clickEvent;
        line.hover = this.hover.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.hover);
        return line;
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("img"));
        o.add("image", (JsonElement)new JsonPrimitive(this.imageProvider.getImage().toString()));
        if (this.imageScale != 1.0) {
            o.add("scale", (JsonElement)new JsonPrimitive((Number)this.imageScale));
        } else if (this.imageWidth != 0 || this.imageHeight != 0) {
            o.add("width", (JsonElement)new JsonPrimitive((Number)this.imageWidth));
            o.add("height", (JsonElement)new JsonPrimitive((Number)this.imageHeight));
        }
        if (this.clickEvent != null) {
            o.add("click", JsonUtils.serializeClickEvent(this.clickEvent));
        }
        if (!this.hover.isEmpty()) {
            JsonArray a = new JsonArray();
            for (String s : this.hover) {
                a.add((JsonElement)new JsonPrimitive(s));
            }
            o.add("hover", (JsonElement)a);
        }
        return o;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private class ButtonInfoImage
    extends Button {
        private final Panel parent;

        private ButtonInfoImage(Panel p) {
            super(0, 0, 0, 0);
            this.parent = p;
            this.checkSize();
        }

        private void checkSize() {
            GuideImageLine.this.imageProvider.bindTexture();
            if (this.width == 1 || this.height == 1) {
                this.width = Math.max(GuideImageLine.this.imageWidth == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) : GuideImageLine.this.imageWidth, 2);
                this.height = Math.max(GuideImageLine.this.imageHeight == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) : GuideImageLine.this.imageHeight, 2);
                double scale = GuideImageLine.this.imageScale < 0.0 ? 1.0 / -GuideImageLine.this.imageScale : GuideImageLine.this.imageScale;
                double w = Math.min((double)this.parent.width, (double)this.width * scale);
                double h = (double)this.height * (w / ((double)this.width * scale));
                this.setWidth((int)w);
                this.setHeight((int)h);
                this.parent.updateWidgetPositions();
            }
        }

        @Override
        public void renderWidget(GuiBase gui) {
            this.checkSize();
            GuideImageLine.this.imageProvider.draw(this, Color4I.NONE);
        }

        @Override
        public void addMouseOverText(GuiBase gui, List<String> list) {
            if (!GuideImageLine.this.hover.isEmpty()) {
                list.addAll(GuideImageLine.this.hover);
            }
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            if (GuiHelper.onClickEvent(GuideImageLine.this.clickEvent)) {
                GuiHelper.playClickSound();
            }
        }
    }
}

