/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.EnumNameMap;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiGuide;
import com.feed_the_beast.ftbl.lib.guide.EmptyGuidePageLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public class GuideListLine
extends EmptyGuidePageLine {
    private static final IDrawableObject CODE_BACKGROUND = new TexturelessRectangle(new Color4I(true, 0x33AAAAAA));
    private static final IDrawableObject SCROLL_BAR_BACKGROUND = new TexturelessRectangle(new Color4I(false, 0x33333333));
    private final List<IGuideTextLine> textLines;
    private final Type type;
    private final Ordering ordering;
    private final int spacing;

    public GuideListLine(GuidePage p, JsonElement json) {
        this.textLines = new ArrayList<IGuideTextLine>();
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("list")) {
                for (JsonElement element : o.get("list").getAsJsonArray()) {
                    IGuideTextLine line = p.createLine(element);
                    if (line == null) continue;
                    this.textLines.add(line);
                }
            }
            this.type = o.has("type") ? Type.NAME_MAP.get(o.get("type").getAsString()) : Type.NONE;
            this.ordering = this.type != Type.HORIZONTAL && o.has("ordering") ? Ordering.NAME_MAP.get(o.get("ordering").getAsString()) : this.type.defaultOrdering;
            this.spacing = o.has("spacing") ? o.get("spacing").getAsInt() : 0;
        } else {
            for (JsonElement element : json.getAsJsonArray()) {
                IGuideTextLine line = p.createLine(element);
                if (line == null) continue;
                this.textLines.add(line);
            }
            this.type = Type.NONE;
            this.ordering = this.type.defaultOrdering;
            this.spacing = 0;
        }
    }

    public GuideListLine(List<IGuideTextLine> l, Type t, Ordering o, int s) {
        this.textLines = l;
        this.type = t;
        this.ordering = this.type == Type.HORIZONTAL ? Ordering.NONE : o;
        this.spacing = s;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new PanelList((GuiGuide)gui, parent.hasFlag(4));
    }

    @Override
    public IGuideTextLine copy(GuidePage page) {
        GuideListLine line = new GuideListLine(new ArrayList<IGuideTextLine>(this.textLines.size()), this.type, this.ordering, this.spacing);
        for (IGuideTextLine line1 : this.textLines) {
            line.textLines.add(line1.copy(page));
        }
        return line;
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("list"));
        o.add("type", (JsonElement)new JsonPrimitive(this.type.func_176610_l()));
        if (this.type != Type.HORIZONTAL && this.ordering != this.type.defaultOrdering) {
            o.add("ordering", (JsonElement)new JsonPrimitive(this.ordering.func_176610_l()));
        }
        if (this.spacing != 0) {
            o.add("spacing", (JsonElement)new JsonPrimitive((Number)this.spacing));
        }
        JsonArray a = new JsonArray();
        for (IGuideTextLine line : this.textLines) {
            a.add(line.getJson());
        }
        o.add("list", (JsonElement)a);
        return o;
    }

    @Override
    public boolean isEmpty() {
        for (IGuideTextLine line : this.textLines) {
            if (line.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private class PanelList
    extends Panel {
        private final GuiGuide gui;
        private final PanelScrollBar scrollBar;
        private final WidgetLayout layout;

        private PanelList(GuiGuide g, boolean unicodeFont) {
            super(((GuideListLine)GuideListLine.this).ordering.size, 0, 0, 0);
            this.gui = g;
            this.scrollBar = new PanelScrollBar(0, 0, 1, 4, 10, this){

                @Override
                public EnumFacing.Plane getPlane() {
                    return EnumFacing.Plane.HORIZONTAL;
                }
            };
            this.scrollBar.background = SCROLL_BAR_BACKGROUND;
            if (unicodeFont) {
                this.addFlags(4);
            }
            this.layout = ((GuideListLine)GuideListLine.this).type.plane == EnumFacing.Plane.VERTICAL ? new WidgetLayout.Vertical(0, GuideListLine.this.spacing, 0) : new WidgetLayout.Horizontal(0, GuideListLine.this.spacing, 0);
        }

        @Override
        public void addWidgets() {
            if (GuideListLine.this.isEmpty()) {
                this.setWidth(0);
                this.setHeight(0);
                return;
            }
            this.setWidth(GuideListLine.this.type == Type.CODE ? 10000 : this.getParentPanel().width - ((GuideListLine)GuideListLine.this).ordering.size);
            for (IGuideTextLine line : GuideListLine.this.textLines) {
                this.add(line.createWidget(this.gui, this));
            }
            this.getParentPanel().add(this.scrollBar);
            this.updateWidgetPositions();
        }

        @Override
        public void updateWidgetPositions() {
            int s;
            if (this.widgets.isEmpty()) {
                this.setWidth(0);
                this.setHeight(0);
                return;
            }
            this.align(this.layout);
            Widget last = (Widget)this.widgets.get(this.widgets.size() - 1);
            if (((GuideListLine)GuideListLine.this).type.plane == EnumFacing.Plane.HORIZONTAL) {
                this.setHeight(0);
                for (Widget widget : this.widgets) {
                    this.setHeight(Math.max(this.height, widget.height));
                }
                s = last.posX + last.width;
            } else {
                this.setHeight(last.posY + last.height);
                s = 0;
                for (Widget widget : this.widgets) {
                    s = Math.max(s, widget.width);
                }
                s += ((GuideListLine)GuideListLine.this).ordering.size;
            }
            this.setWidth(Math.min(s, this.getParentPanel().width) - ((GuideListLine)GuideListLine.this).ordering.size);
            this.scrollBar.setWidth(this.width + ((GuideListLine)GuideListLine.this).ordering.size);
            this.scrollBar.setElementSize(s - ((GuideListLine)GuideListLine.this).ordering.size);
            this.scrollBar.setSrollStepFromOneElementSize(10);
            this.scrollBar.sliderSize = this.scrollBar.width / 10;
        }

        @Override
        protected void renderWidget(GuiBase gui, Widget widget, int index, int ax, int ay, int w, int h) {
            widget.renderWidget(gui);
            if (((GuideListLine)GuideListLine.this).ordering.size > 0 && widget.getClass() != Widget.class && !(widget instanceof PanelList)) {
                switch (GuideListLine.this.ordering) {
                    case BULLET: {
                        GuiGuide.TEX_BULLET.draw(ax - 7, widget.getAY() + 3, 4, 4, gui.getContentColor());
                        break;
                    }
                    case NUMBER: {
                        String n = Integer.toString(index + 1);
                        gui.drawString(n, ax - 1 - gui.getFont().func_78256_a(n), widget.getAY() + 1, gui.getContentColor());
                        break;
                    }
                    case LETTER: {
                        char c = (char)(97 + index);
                        if (c > 'z') {
                            c = (char)(65 + index);
                        }
                        if (c > 'Z') {
                            c = '-';
                        }
                        String n = Character.toString(c);
                        gui.drawString(n, ax - 1 - gui.getFont().func_78256_a(n), widget.getAY() + 1, gui.getContentColor());
                    }
                }
            }
        }

        @Override
        protected void renderPanelBackground(GuiBase gui, int ax, int ay) {
            if (GuideListLine.this.type == Type.CODE) {
                CODE_BACKGROUND.draw(ax - ((GuideListLine)GuideListLine.this).ordering.size, ay, this.width + ((GuideListLine)GuideListLine.this).ordering.size, this.height, Color4I.NONE);
            }
        }
    }

    public static enum Type implements IStringSerializable
    {
        NONE("none", EnumFacing.Plane.VERTICAL, Ordering.BULLET),
        CODE("code", EnumFacing.Plane.VERTICAL, Ordering.NONE),
        HORIZONTAL("horizontal", EnumFacing.Plane.HORIZONTAL, Ordering.NONE);

        public static final EnumNameMap<Type> NAME_MAP;
        private final String name;
        public final EnumFacing.Plane plane;
        public final Ordering defaultOrdering;

        private Type(String s, EnumFacing.Plane d, Ordering o) {
            this.name = s;
            this.plane = d;
            this.defaultOrdering = o;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            NAME_MAP = new EnumNameMap((Enum[])Type.values(), false, (Enum)NONE);
        }
    }

    public static enum Ordering implements IStringSerializable
    {
        NONE("none", 0),
        BULLET("bullet", 8),
        NUMBER("number", 12),
        LETTER("letter", 10);

        public static final EnumNameMap<Ordering> NAME_MAP;
        private final String name;
        public final int size;

        private Ordering(String n2, int s) {
            this.name = n2;
            this.size = s;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            NAME_MAP = new EnumNameMap((Enum[])Ordering.values(), false, (Enum)BULLET);
        }
    }
}

