/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.events.GuideVariableEvent;
import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiGuide;
import com.feed_the_beast.ftbl.lib.guide.EmptyGuidePageLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class GuideSwitchLine
extends EmptyGuidePageLine {
    private final GuidePage page;
    private final Map<String, List<IGuideTextLine>> textLinesMap;
    private final ResourceLocation id;

    public GuideSwitchLine(GuidePage p, JsonElement json) {
        this.textLinesMap = new HashMap<String, List<IGuideTextLine>>();
        this.page = p;
        JsonObject o = json.getAsJsonObject();
        this.id = new ResourceLocation(o.get("var").getAsString());
        for (Map.Entry entry : o.get("switch").getAsJsonObject().entrySet()) {
            ArrayList<IGuideTextLine> textLines = new ArrayList<IGuideTextLine>();
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    IGuideTextLine line = this.page.createLine(element);
                    if (line == null) continue;
                    textLines.add(line);
                }
            } else {
                textLines.add(this.page.createLine((JsonElement)entry.getValue()));
            }
            this.textLinesMap.put((String)entry.getKey(), (List<IGuideTextLine>)textLines);
        }
    }

    public GuideSwitchLine(GuidePage p, Map<String, List<IGuideTextLine>> m, ResourceLocation i) {
        this.page = p;
        this.textLinesMap = m;
        this.id = i;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new PanelList((GuiGuide)gui);
    }

    @Override
    public IGuideTextLine copy(GuidePage page) {
        GuideSwitchLine line = new GuideSwitchLine(page, new HashMap<String, List<IGuideTextLine>>(), this.id);
        for (Map.Entry<String, List<IGuideTextLine>> entry : this.textLinesMap.entrySet()) {
            ArrayList<IGuideTextLine> textLines = new ArrayList<IGuideTextLine>();
            for (IGuideTextLine line1 : textLines) {
                textLines.add(line1.copy(page));
            }
            line.textLinesMap.put(entry.getKey(), textLines);
        }
        return line;
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("switch"));
        o.add("var", (JsonElement)new JsonPrimitive(this.id.toString()));
        JsonObject o1 = new JsonObject();
        for (Map.Entry<String, List<IGuideTextLine>> entry : this.textLinesMap.entrySet()) {
            JsonArray a = new JsonArray();
            for (IGuideTextLine line : entry.getValue()) {
                a.add(line.getJson());
            }
            o.add(entry.getKey(), (JsonElement)a);
        }
        o.add("switch", (JsonElement)o1);
        return o;
    }

    @Override
    public boolean isEmpty() {
        if (this.textLinesMap.isEmpty()) {
            return true;
        }
        for (List<IGuideTextLine> lines : this.textLinesMap.values()) {
            for (IGuideTextLine line : lines) {
                if (line.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public List<IGuideTextLine> get(String id) {
        List<IGuideTextLine> list = this.textLinesMap.get(id);
        if (list == null) {
            list = this.textLinesMap.get("default");
        }
        return list == null || list.isEmpty() ? Collections.emptyList() : list;
    }

    private class PanelList
    extends Panel {
        private final GuiGuide gui;

        private PanelList(GuiGuide g) {
            super(0, 0, 0, 0);
            this.gui = g;
        }

        @Override
        public void addWidgets() {
            if (!GuideSwitchLine.this.isEmpty()) {
                GuideVariableEvent event = new GuideVariableEvent(Side.CLIENT, GuideSwitchLine.this.page, GuideSwitchLine.this.id);
                MinecraftForge.EVENT_BUS.post((Event)event);
                for (IGuideTextLine line : GuideSwitchLine.this.get(event.getValue())) {
                    this.getParentPanel().add(line.createWidget(this.gui, this.getParentPanel()));
                }
            }
        }
    }
}

