/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemStackSerializer {
    public static ItemStack parseItem(String input) {
        if ((input = input.trim()).isEmpty()) {
            return ItemStackTools.getEmptyStack();
        }
        String[] s1 = input.split(" ", 4);
        if (s1.length == 0) {
            return ItemStackTools.getEmptyStack();
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s1[0]));
        if (item == null) {
            return ItemStackTools.getEmptyStack();
        }
        int stackSize = 1;
        int meta = 0;
        if (s1.length >= 2) {
            stackSize = MathHelper.func_82715_a((String)s1[1], (int)1);
        }
        if (s1.length >= 3) {
            meta = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)s1[2], (int)0);
        }
        ItemStack itemstack = new ItemStack(item, stackSize, meta);
        if (s1.length >= 4) {
            try {
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)s1[3]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemstack;
    }

    public static String toString(ItemStack is) {
        if (ItemStackTools.isEmpty((ItemStack)is)) {
            return "";
        }
        return Item.field_150901_e.func_177774_c((Object)is.func_77973_b()) + " " + ItemStackTools.getStackSize((ItemStack)is) + ' ' + is.func_77952_i();
    }

    public static JsonElement serialize(ItemStack is) {
        String s = ItemStackSerializer.toString(is);
        return s.isEmpty() ? JsonNull.INSTANCE : new JsonPrimitive(s);
    }

    public static ItemStack deserialize(JsonElement e) {
        if (e.isJsonNull()) {
            return ItemStackTools.getEmptyStack();
        }
        if (e.isJsonPrimitive()) {
            return ItemStackSerializer.parseItem(e.getAsString());
        }
        try {
            return ItemStackTools.loadFromNBT((NBTTagCompound)JsonToNBT.func_180713_a((String)e.toString()));
        }
        catch (Exception ex) {
            return ItemStackTools.getEmptyStack();
        }
    }
}

