/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.reg;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class IDRegistry<K>
implements INBTSerializable<NBTTagCompound> {
    private final TIntObjectHashMap<K> IDToKey = new TIntObjectHashMap();
    private final Map<K, Integer> KeyToID = new HashMap<K, Integer>();

    public void clear() {
        if (!this.IDToKey.isEmpty()) {
            this.IDToKey.clear();
            this.KeyToID.clear();
        }
    }

    @Nullable
    public K getKeyFromID(int numID) {
        return (K)this.IDToKey.get(numID);
    }

    public int getIDFromKey(K key) {
        return this.IDToKey.containsValue(key) ? this.KeyToID.get(key) : 0;
    }

    public void generateIDs(Collection<K> keys) {
        this.clear();
        keys.forEach(key -> {
            int i = this.IDToKey.size() + 1;
            this.KeyToID.put(key, i);
            this.IDToKey.put(i, key);
        });
    }

    public int generateID(K key) {
        int i = this.getIDFromKey(key);
        if (i == 0) {
            i = this.IDToKey.size() + 1;
            this.KeyToID.put(key, i);
            this.IDToKey.put(i, key);
        }
        return i;
    }

    public abstract String createStringFromKey(K var1);

    public abstract K createKeyFromString(String var1);

    public void serialize(TIntObjectHashMap<String> map) {
        this.KeyToID.forEach((key, value) -> {
            String cfr_ignored_0 = (String)map.put(value.intValue(), (Object)this.createStringFromKey(key));
        });
    }

    public void deserialize(TIntObjectHashMap<String> map) {
        map.forEachEntry((key, value) -> {
            K value1 = this.createKeyFromString((String)value);
            this.IDToKey.put(key, value1);
            this.KeyToID.put(value1, key);
            return true;
        });
    }

    public String toString() {
        return this.IDToKey.toString();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.KeyToID.forEach((key, value) -> nbt.func_74768_a(this.createStringFromKey(key), value.intValue()));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.clear();
        for (String key : nbt.func_150296_c()) {
            int val = nbt.func_74762_e(key);
            K key1 = this.createKeyFromString(key);
            this.IDToKey.put(val, key1);
            this.KeyToID.put(key1, val);
        }
    }
}

