/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.lib.EnumNameMap;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbl.lib.math.EntityDimPos;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ServerUtils {
    public static final EnumNameMap<TextFormatting> TEXT_FORMATTING_NAME_MAP = new EnumNameMap((Enum[])TextFormatting.values(), false);

    public static boolean teleportPlayer(Entity entity, EntityDimPos pos) {
        return ServerUtils.teleportPlayer(entity, pos.pos, pos.dim);
    }

    public static boolean teleportPlayer(Entity entity, BlockDimPos pos) {
        return ServerUtils.teleportPlayer(entity, pos.toVec(), pos.dim);
    }

    public static boolean teleportPlayer(Entity entity, Vec3d pos, int dim) {
        EntityPlayerMP player;
        entity.field_70143_R = 0.0f;
        EntityPlayerMP entityPlayerMP = player = entity instanceof EntityPlayer ? (EntityPlayerMP)entity : null;
        if (dim == entity.field_71093_bK) {
            if (pos.field_72450_a == entity.field_70165_t && pos.field_72448_b == entity.field_70163_u && pos.field_72449_c == entity.field_70161_v) {
                return true;
            }
            if (player != null) {
                player.field_71135_a.func_147364_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player.field_70177_z, player.field_70125_A);
                return true;
            }
        }
        int from = entity.field_71093_bK;
        float rotationYaw = entity.field_70177_z;
        float rotationPitch = entity.field_70125_A;
        MinecraftServer server = ServerUtils.getServer();
        WorldServer fromDim = server.func_71218_a(from);
        WorldServer toDim = server.func_71218_a(dim);
        if (player != null) {
            server.func_184103_al().transferPlayerToDimension(player, dim, (Teleporter)new TeleporterBlank(toDim));
            if (from == 1 && entity.func_70089_S()) {
                toDim.func_72838_d(entity);
                toDim.func_72866_a(entity, false);
            }
        } else {
            NBTTagCompound tagCompound = new NBTTagCompound();
            entity.func_189511_e(tagCompound);
            Class<?> entityClass = entity.getClass();
            fromDim.func_72900_e(entity);
            try {
                Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(toDim);
                newEntity.func_70020_e(tagCompound);
                newEntity.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, rotationYaw, rotationPitch);
                newEntity.field_98038_p = true;
                toDim.func_72838_d(newEntity);
                newEntity.field_98038_p = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        entity.field_70143_R = 0.0f;
        entity.field_70177_z = rotationYaw;
        entity.field_70125_A = rotationPitch;
        if (player != null) {
            player.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        } else {
            entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        return true;
    }

    public static double getMovementFactor(int dim) {
        switch (dim) {
            case 0: {
                return 1.0;
            }
            case -1: {
                return 8.0;
            }
            case 1: {
                return 1.0;
            }
        }
        WorldServer w = DimensionManager.getWorld((int)dim);
        return w == null ? 1.0 : w.field_73011_w.getMovementFactor();
    }

    @Nullable
    public static BlockDimPos getSpawnPoint(int dim) {
        WorldServer w = DimensionManager.getWorld((int)dim);
        return w == null ? null : new BlockDimPos((Vec3i)w.func_175694_M(), dim);
    }

    public static ITextComponent getChatComponent(Object o) {
        return o instanceof ITextComponent ? (ITextComponent)o : new TextComponentString(String.valueOf(o));
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static boolean hasOnlinePlayers() {
        return !ServerUtils.getServer().func_184103_al().func_181057_v().isEmpty();
    }

    public static WorldServer getServerWorld() {
        return ServerUtils.getServer().func_71218_a(0);
    }

    public static boolean isOP(GameProfile p) {
        MinecraftServer server = ServerUtils.getServer();
        return server == null || server.func_184103_al().func_152596_g(p);
    }

    public static Collection<ICommand> getAllCommands(MinecraftServer server, ICommandSender sender) {
        HashSet<ICommand> commands = new HashSet<ICommand>();
        for (ICommand c : server.func_71187_D().func_71555_a().values()) {
            if (!c.func_184882_a(server, sender)) continue;
            commands.add(c);
        }
        return commands;
    }

    @Nullable
    public static Boolean canMobSpawn(World world, BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return null;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)pos) || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) >= 8) {
            return null;
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o() + 0.01, (double)pos.func_177952_p() + 0.2, (double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + 1.8, (double)pos.func_177952_p() + 0.8);
        if (!world.func_72855_b(aabb) || world.func_72953_d(aabb)) {
            return null;
        }
        if (chunk.func_177413_a(EnumSkyBlock.SKY, pos) >= 8) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Nullable
    public static Entity getEntityByUUID(World worldObj, UUID uuid) {
        for (Entity e : worldObj.field_72996_f) {
            if (!e.func_110124_au().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    public static void addTickable(MinecraftServer server, ITickable tickable) {
        server.field_71322_p.add(tickable);
    }

    public static Set<ICommand> getCommandSet(CommandHandler handler) {
        return handler.field_71561_b;
    }

    private static class TeleporterBlank
    extends Teleporter {
        private TeleporterBlank(WorldServer w) {
            super(w);
        }

        public boolean func_85188_a(Entity e) {
            return true;
        }

        public boolean func_180620_b(Entity e, float f) {
            return true;
        }

        public void func_180266_a(Entity entity, float f) {
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70125_A, entity.field_70177_z);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70143_R = 0.0f;
        }

        public void func_85189_a(long l) {
        }
    }
}

