/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.EnumReloadType;
import com.feed_the_beast.ftbl.api.ISyncData;
import com.feed_the_beast.ftbl.api_impl.PackMode;
import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.lib.util.NetUtils;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class MessageReload
extends MessageToClient<MessageReload> {
    private int typeID;
    private NBTTagCompound syncData;
    private String currentMode;
    private UUID universeID;

    public MessageReload() {
    }

    public MessageReload(EnumReloadType t, NBTTagCompound sync) {
        this.typeID = t.ordinal();
        this.syncData = sync;
        this.currentMode = SharedServerData.INSTANCE.getPackMode().func_176610_l();
        this.universeID = SharedServerData.INSTANCE.getUniverseID();
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void toBytes(ByteBuf io) {
        io.writeByte(this.typeID);
        ByteBufUtils.writeTag((ByteBuf)io, (NBTTagCompound)this.syncData);
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.currentMode);
        NetUtils.writeUUID(io, this.universeID);
    }

    public void fromBytes(ByteBuf io) {
        this.typeID = io.readUnsignedByte();
        this.syncData = ByteBufUtils.readTag((ByteBuf)io);
        this.currentMode = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.universeID = NetUtils.readUUID(io);
    }

    @Override
    public void onMessage(MessageReload m, EntityPlayer player) {
        EnumReloadType type = m.typeID >= EnumReloadType.VALUES.length ? EnumReloadType.MODE_CHANGED : EnumReloadType.VALUES[m.typeID];
        SharedClientData.INSTANCE.universeID = m.universeID;
        SharedClientData.INSTANCE.currentMode = new PackMode(m.currentMode);
        for (String key : m.syncData.func_150296_c()) {
            ISyncData nbt = FTBLibModCommon.SYNCED_DATA.get(key);
            if (nbt == null) continue;
            nbt.readSyncData(m.syncData.func_74775_l(key));
        }
        if (type != EnumReloadType.RELOAD_COMMAND) {
            FTBLibIntegrationInternal.API.reload(Side.CLIENT, (ICommandSender)player, type);
        }
    }
}

