/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.block;

import com.google.common.base.Function;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.render.block.BakedInfBlockModel;
import com.infinityraider.infinitylib.render.block.IBlockRenderingHandler;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockRenderer<B extends BlockBase>
implements IModel {
    private final B block;
    private final IBlockRenderingHandler<B> renderer;

    public BlockRenderer(IBlockRenderingHandler<B> renderer) {
        this.block = renderer.getBlock();
        this.renderer = renderer;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.renderer.getAllTextures();
    }

    public B getBlock() {
        return this.block;
    }

    public IBlockRenderingHandler<B> getRenderer() {
        return this.renderer;
    }

    public BakedInfBlockModel<B> bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedInfBlockModel<B>(this.block, format, this.renderer, bakedTextureGetter, this.renderer.doInventoryRendering());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

