/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.item;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.render.item.IItemRenderingHandler;
import com.infinityraider.infinitylib.render.item.ItemQuadGenerator;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderItemAuto<T extends Item>
implements IItemRenderingHandler {
    private final Map<String, List<BakedQuad>> models = new ConcurrentHashMap<String, List<BakedQuad>>();
    private final T item;

    public RenderItemAuto(T item) {
        this.item = item;
    }

    public T getItem() {
        return this.item;
    }

    @Override
    public List<ResourceLocation> getAllTextures() {
        return ((IAutoRenderedItem)this.item).getAllTextures();
    }

    @Override
    public void renderItem(ITessellator tessellator, World world, ItemStack stack, EntityLivingBase entity) {
        String id = ((IAutoRenderedItem)this.item).getModelId(stack);
        List<BakedQuad> model = this.models.get(id);
        if (model == null) {
            InfinityLib.instance.getLogger().debug("Baking Item Model: " + id + "!", new Object[0]);
            model = ItemQuadGenerator.generateItemQuads(DefaultVertexFormats.field_176599_b, tessellator::getIcon, ((IAutoRenderedItem)this.item).getBaseTexture(stack), ((IAutoRenderedItem)this.item).getOverlayTextures(stack));
            this.models.put(id, model);
        }
        tessellator.addQuads(model);
    }
}

