/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.model;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.tessellation.VertexData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Matrix4f;
import org.joml.Vector4f;

@SideOnly(value=Side.CLIENT)
public class ModelTechne<M extends ModelBase> {
    private final M model;
    private final List<ModelRenderer> modelRenderers;
    private final List<Tuple<ModelRenderer, List<TexturedQuad>>> texturedQuads;
    private boolean diffuseLighting;

    public ModelTechne(M techneModel) {
        this.model = techneModel;
        this.modelRenderers = ModelTechne.compileModelRendererList(this.getModel());
        this.texturedQuads = ModelTechne.compileTexturedQuadList(this.getModelRenderers());
    }

    public ModelTechne<M> setDiffuseLighting(boolean status) {
        this.diffuseLighting = status;
        return this;
    }

    public boolean getDiffuseLighting() {
        return this.diffuseLighting;
    }

    public M getModel() {
        return this.model;
    }

    public List<ModelRenderer> getModelRenderers() {
        return this.modelRenderers;
    }

    public List<Tuple<ModelRenderer, List<TexturedQuad>>> getTexturedQuads() {
        return this.texturedQuads;
    }

    public List<BakedQuad> getBakedQuads(VertexFormat format) {
        return this.getBakedQuads(format, null);
    }

    public List<BakedQuad> getBakedQuads(VertexFormat format, TextureAtlasSprite icon) {
        return this.getBakedQuads(format, icon, 1.0f);
    }

    public List<BakedQuad> getBakedQuads(VertexFormat format, TextureAtlasSprite icon, float scale) {
        Matrix4f matrix = new Matrix4f().identity();
        return this.getTexturedQuads().stream().flatMap(t -> ((List)t.func_76340_b()).stream().map(quad -> this.createBakedQuad(format, (ModelRenderer)t.func_76341_a(), (TexturedQuad)quad, matrix, scale * 0.0625f, icon))).collect(Collectors.toList());
    }

    private BakedQuad createBakedQuad(VertexFormat format, ModelRenderer renderer, TexturedQuad quad, Matrix4f matrix, float scale, TextureAtlasSprite icon) {
        ModelTechne.loadRenderMatrix(renderer, matrix, scale);
        Vec3d vec3d = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
        Vec3d vec3d1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
        Vec3d vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
        Vector4f normal = new Vector4f((float)vec3d2.field_72450_a, (float)vec3d2.field_72448_b, (float)vec3d2.field_72449_c, 1.0f);
        matrix.transform(normal);
        Vector4f pos = new Vector4f();
        VertexData[] vertexData = new VertexData[quad.field_78239_a.length];
        for (int i = 0; i < vertexData.length; ++i) {
            PositionTextureVertex vertex = quad.field_78239_a[i];
            vertexData[i] = new VertexData(format);
            pos.set((float)vertex.field_78243_a.field_72450_a * scale, (float)vertex.field_78243_a.field_72448_b * scale, (float)vertex.field_78243_a.field_72449_c * scale, 1.0f);
            matrix.transform(pos);
            vertexData[i].setXYZ(pos.x, pos.y, pos.z);
            vertexData[i].setRGBA(1.0f, 1.0f, 1.0f, 1.0f);
            vertexData[i].setNormal(normal.x, normal.y, normal.z);
            if (icon != null) {
                vertexData[i].setUV(icon.func_94214_a((double)(vertex.field_78241_b * 16.0f)), icon.func_94207_b((double)(vertex.field_78242_c * 16.0f)));
                continue;
            }
            vertexData[i].setUV(vertex.field_78241_b, vertex.field_78242_c);
        }
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(format);
        quadBuilder.setTexture(icon);
        quadBuilder.setApplyDiffuseLighting(this.getDiffuseLighting());
        for (VertexData data : vertexData) {
            data.applyVertexData(quadBuilder);
        }
        return quadBuilder.build();
    }

    private static List<ModelRenderer> compileModelRendererList(ModelBase model) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (Field field : model.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(ModelRenderer.class)) continue;
            field.setAccessible(true);
            try {
                list.add((ModelRenderer)field.get(model));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ImmutableList.copyOf(list);
    }

    private static List<Tuple<ModelRenderer, List<TexturedQuad>>> compileTexturedQuadList(List<ModelRenderer> modelRenderers) {
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (ModelRenderer model : modelRenderers) {
            ArrayList quadList = new ArrayList();
            for (ModelBox box : model.field_78804_l) {
                Field fieldQuads = null;
                for (Field field : box.getClass().getDeclaredFields()) {
                    if (!field.getType().isAssignableFrom(TexturedQuad[].class)) continue;
                    fieldQuads = field;
                    break;
                }
                if (fieldQuads == null) continue;
                fieldQuads.setAccessible(true);
                try {
                    Collections.addAll(quadList, (TexturedQuad[])fieldQuads.get(box));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            list.add(new Tuple((Object)model, (Object)ImmutableList.copyOf(quadList)));
        }
        return ImmutableList.copyOf(list);
    }

    private static void loadRenderMatrix(ModelRenderer renderer, Matrix4f matrix, float scale) {
        matrix.identity().rotate((float)Math.toRadians(180.0), 1.0f, 0.0f, 0.0f).translate(8.0f * scale, -24.0f * scale, -8.0f * scale).translate(renderer.field_82906_o + renderer.field_78800_c * scale, renderer.field_82908_p + renderer.field_78797_d * scale, renderer.field_82907_q + renderer.field_78798_e * scale);
        if (renderer.field_78808_h != 0.0f) {
            matrix.rotate(renderer.field_78808_h, 0.0f, 0.0f, 1.0f);
        }
        if (renderer.field_78796_g != 0.0f) {
            matrix.rotate(renderer.field_78796_g, 0.0f, 1.0f, 0.0f);
        }
        if (renderer.field_78795_f != 0.0f) {
            matrix.rotate(renderer.field_78795_f, 1.0f, 0.0f, 0.0f);
        }
    }
}

