/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.tessellation.TessellatorAbstractBase;
import com.infinityraider.infinitylib.render.tessellation.VertexData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Vector4f;

@SideOnly(value=Side.CLIENT)
public class TessellatorBakedQuad
extends TessellatorAbstractBase {
    public static final int DRAW_MODE_NOT_DRAWING = -1;
    public static final int DRAW_MODE_QUADS = 4;
    private static final ThreadLocal<TessellatorBakedQuad> INSTANCE = new ThreadLocal();
    private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
    private final List<VertexData> vertexData = new ArrayList<VertexData>();
    private int drawMode = -1;
    private EnumFacing face;
    private TextureAtlasSprite icon;
    private Function<ResourceLocation, TextureAtlasSprite> textureFunction;

    public static TessellatorBakedQuad getInstance() {
        TessellatorBakedQuad tessellator = INSTANCE.get();
        if (tessellator == null) {
            tessellator = new TessellatorBakedQuad();
            INSTANCE.set(tessellator);
        }
        return tessellator;
    }

    private TessellatorBakedQuad() {
    }

    @Override
    protected void onStartDrawingQuadsCall() {
        this.startDrawing(4);
    }

    public void startDrawing(int mode) {
        if (this.drawMode != -1) {
            throw new RuntimeException("ALREADY CONSTRUCTING VERTICES");
        }
        this.drawMode = mode;
    }

    @Override
    public List<BakedQuad> getQuads() {
        return ImmutableList.copyOf(this.quads);
    }

    @Override
    protected void onDrawCall() {
        if (this.drawMode == -1) {
            throw new RuntimeException("NOT CONSTRUCTING VERTICES");
        }
        this.quads.clear();
        this.vertexData.clear();
        this.drawMode = -1;
        this.textureFunction = null;
        this.face = null;
    }

    @Override
    public void addQuads(List<BakedQuad> quads) {
        if (this.drawMode != -1) {
            for (BakedQuad quad : quads) {
                UnpackedBakedQuad trans = this.transformQuad(quad);
                if (trans.func_178210_d() != this.face) continue;
                this.quads.add((BakedQuad)trans);
            }
        } else {
            throw new RuntimeException("NOT CONSTRUCTING VERTICES");
        }
    }

    @Override
    public void addVertexWithUV(float x, float y, float z, TextureAtlasSprite icon, float u, float v) {
        if (icon == null) {
            icon = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        this.icon = icon;
        this.addVertexWithUV(x, y, z, icon.func_94214_a((double)u), icon.func_94207_b((double)v));
    }

    @Override
    public void addVertexWithUV(float x, float y, float z, float u, float v) {
        if (this.drawMode == -1) {
            throw new RuntimeException("NOT CONSTRUCTING VERTICES");
        }
        Vector4f pos = new Vector4f(x, y, z, 1.0f);
        this.transform(pos);
        VertexData vert = new VertexData(this.getVertexFormat());
        vert.setXYZ(pos.x, pos.y, pos.z);
        vert.setUV(u, v);
        vert.setRGBA(this.r, this.g, this.b, this.a);
        vert.setNormal(this.normal.x, this.normal.y, this.normal.z);
        this.vertexData.add(vert);
        if (this.vertexData.size() == this.drawMode) {
            EnumFacing dir = EnumFacing.func_176737_a((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
            if (dir == this.face) {
                UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.getVertexFormat());
                quadBuilder.setQuadTint(this.getTintIndex());
                quadBuilder.setApplyDiffuseLighting(this.getApplyDiffuseLighting());
                quadBuilder.setQuadOrientation(dir);
                quadBuilder.setTexture(this.icon);
                for (VertexData vertex : this.vertexData) {
                    vertex.applyVertexData(quadBuilder);
                }
                this.quads.add((BakedQuad)quadBuilder.build());
            }
            this.vertexData.clear();
        }
    }

    @Override
    public void drawScaledFace(float minX, float minY, float maxX, float maxY, EnumFacing face, TextureAtlasSprite icon, float offset) {
        if (this.face == face) {
            super.drawScaledFace(minX, minY, maxX, maxY, face, icon, offset);
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ResourceLocation loc) {
        if (this.textureFunction == null || loc == null) {
            return super.getIcon(loc);
        }
        return (TextureAtlasSprite)this.textureFunction.apply((Object)loc);
    }

    @Override
    protected void applyColorMultiplier(EnumFacing side) {
    }

    public TessellatorBakedQuad setTextureFunction(Function<ResourceLocation, TextureAtlasSprite> function) {
        this.textureFunction = function;
        return this;
    }

    public TessellatorBakedQuad setCurrentFace(EnumFacing face) {
        this.face = face;
        return this;
    }
}

