/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RayTraceHelper {
    @Nullable
    public static RayTraceResult getTargetBlock(Entity entity, double distance) {
        Optional<Tuple<Vec3d, Vec3d>> eyesAndTrace = RayTraceHelper.getEyesAndTraceVectors(entity, distance);
        if (!eyesAndTrace.isPresent()) {
            return null;
        }
        return entity.func_130014_f_().func_147447_a((Vec3d)eyesAndTrace.get().func_76341_a(), (Vec3d)eyesAndTrace.get().func_76340_b(), false, false, true);
    }

    @Nullable
    public static RayTraceResult getTargetEntityOrBlock(Entity entity, double distance) {
        Optional<Tuple<Vec3d, Vec3d>> eyesAndTrace = RayTraceHelper.getEyesAndTraceVectors(entity, distance);
        if (!eyesAndTrace.isPresent()) {
            return null;
        }
        return RayTraceHelper.rayTraceBlocksForEntity(entity, entity.func_130014_f_(), (Vec3d)eyesAndTrace.get().func_76341_a(), (Vec3d)eyesAndTrace.get().func_76340_b(), false, false, true);
    }

    @Nullable
    public static RayTraceResult getTargetEntityOrBlock(Entity entity, double distance, Class<? extends Entity> entityClass) {
        Optional<Tuple<Vec3d, Vec3d>> eyesAndTrace = RayTraceHelper.getEyesAndTraceVectors(entity, distance);
        if (!eyesAndTrace.isPresent()) {
            return null;
        }
        return RayTraceHelper.rayTraceBlocksForEntity(entity, entity.func_130014_f_(), (Vec3d)eyesAndTrace.get().func_76341_a(), (Vec3d)eyesAndTrace.get().func_76340_b(), false, false, true, entityClass);
    }

    @Nullable
    public static RayTraceResult getTargetEntityOrBlock(Entity entity, double distance, Predicate<? super Entity> filter) {
        Optional<Tuple<Vec3d, Vec3d>> eyesAndTrace = RayTraceHelper.getEyesAndTraceVectors(entity, distance);
        if (!eyesAndTrace.isPresent()) {
            return null;
        }
        return RayTraceHelper.rayTraceBlocksForEntity(entity, entity.func_130014_f_(), (Vec3d)eyesAndTrace.get().func_76341_a(), (Vec3d)eyesAndTrace.get().func_76340_b(), false, false, true, filter);
    }

    private static Optional<Tuple<Vec3d, Vec3d>> getEyesAndTraceVectors(Entity entity, double distance) {
        Vec3d eyes = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d look = entity.func_70040_Z();
        if (look == null) {
            return Optional.empty();
        }
        Vec3d trace = eyes.func_72441_c(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        return Optional.of(new Tuple((Object)eyes, (Object)trace));
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksForEntity(Entity entity, World world, Vec3d start, Vec3d ray, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return RayTraceHelper.rayTraceBlocksForEntity(entity, world, start, ray, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, Entity.class);
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksForEntity(Entity entity, World world, Vec3d start, Vec3d ray, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, Class<? extends Entity> entityClass) {
        return RayTraceHelper.rayTraceBlocksForEntity(entity, world, start, ray, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, new PredicateInstanceOf<Entity>(entityClass));
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksForEntity(Entity entity, World world, Vec3d start, Vec3d ray, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, Predicate<? super Entity> filter) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(ray.field_72450_a) || Double.isNaN(ray.field_72448_b) || Double.isNaN(ray.field_72449_c))) {
                RayTraceResult raytraceresult;
                int x2 = MathHelper.func_76128_c((double)ray.field_72450_a);
                int y2 = MathHelper.func_76128_c((double)ray.field_72448_b);
                int z2 = MathHelper.func_76128_c((double)ray.field_72449_c);
                int x1 = MathHelper.func_76128_c((double)start.field_72450_a);
                int y1 = MathHelper.func_76128_c((double)start.field_72448_b);
                int z1 = MathHelper.func_76128_c((double)start.field_72449_c);
                BlockPos pos = new BlockPos(x1, y1, z1);
                IBlockState state = world.func_180495_p(pos);
                Block blockStart = state.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || state.func_185890_d(world, pos) != Block.field_185506_k) && blockStart.func_176209_a(state, stopOnLiquid) && (raytraceresult = state.func_185910_a(world, pos, start, ray)) != null) {
                    return raytraceresult;
                }
                RayTraceResult result = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (x1 == x2 && y1 == y2 && z1 == z2) {
                        return returnLastUncollidableBlock ? result : null;
                    }
                    Tuple<Double, Boolean> xStep = RayTraceHelper.step(x1, x2);
                    Tuple<Double, Boolean> yStep = RayTraceHelper.step(y1, y2);
                    Tuple<Double, Boolean> zStep = RayTraceHelper.step(z1, z2);
                    boolean flagX = (Boolean)xStep.func_76340_b();
                    boolean flagY = (Boolean)yStep.func_76340_b();
                    boolean flagZ = (Boolean)zStep.func_76340_b();
                    double dX = (Double)xStep.func_76341_a();
                    double dY = (Double)yStep.func_76341_a();
                    double dZ = (Double)zStep.func_76341_a();
                    double xNew = 999.0;
                    double yNew = 999.0;
                    double zNew = 999.0;
                    double deltaX = ray.field_72450_a - start.field_72450_a;
                    double deltaY = ray.field_72448_b - start.field_72448_b;
                    double deltaZ = ray.field_72449_c - start.field_72449_c;
                    if (flagX) {
                        xNew = (dX - start.field_72450_a) / deltaX;
                    }
                    if (flagY) {
                        yNew = (dY - start.field_72448_b) / deltaY;
                    }
                    if (flagZ) {
                        zNew = (dZ - start.field_72449_c) / deltaZ;
                    }
                    if (xNew == -0.0) {
                        xNew = -1.0E-4;
                    }
                    if (yNew == -0.0) {
                        yNew = -1.0E-4;
                    }
                    if (zNew == -0.0) {
                        zNew = -1.0E-4;
                    }
                    if (xNew < yNew && xNew < zNew) {
                        enumfacing = x2 > x1 ? EnumFacing.WEST : EnumFacing.EAST;
                        start = new Vec3d(dX, start.field_72448_b + deltaY * xNew, start.field_72449_c + deltaZ * xNew);
                    } else if (yNew < zNew) {
                        enumfacing = y2 > y1 ? EnumFacing.DOWN : EnumFacing.UP;
                        start = new Vec3d(start.field_72450_a + deltaX * yNew, dY, start.field_72449_c + deltaZ * yNew);
                    } else {
                        enumfacing = z2 > z1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        start = new Vec3d(start.field_72450_a + deltaX * zNew, start.field_72448_b + deltaY * zNew, dZ);
                    }
                    x1 = MathHelper.func_76128_c((double)start.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    y1 = MathHelper.func_76128_c((double)start.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    z1 = MathHelper.func_76128_c((double)start.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    pos = new BlockPos(x1, y1, z1);
                    List entities = world.func_175674_a(entity, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), filter);
                    Entity closest = null;
                    double dist = 998001.0;
                    for (Entity collided : entities) {
                        double distTo = (collided.field_70165_t - entity.field_70165_t) * (collided.field_70165_t - entity.field_70165_t) + (collided.field_70163_u - entity.field_70163_u) * (collided.field_70163_u - entity.field_70163_u) + (collided.field_70161_v - entity.field_70161_v) * (collided.field_70161_v - entity.field_70161_v);
                        if (!(distTo < dist)) continue;
                        dist = distTo;
                        closest = collided;
                    }
                    if (closest != null) {
                        return new RayTraceResult(closest);
                    }
                    IBlockState stateAt = world.func_180495_p(pos);
                    Block block = stateAt.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && stateAt.func_185904_a() != Material.field_151567_E && stateAt.func_185890_d(world, pos) == Block.field_185506_k) continue;
                    if (block.func_176209_a(stateAt, stopOnLiquid)) {
                        RayTraceResult newResult = stateAt.func_185910_a(world, pos, start, ray);
                        if (newResult == null) continue;
                        return newResult;
                    }
                    result = new RayTraceResult(RayTraceResult.Type.MISS, start, enumfacing, pos);
                }
                return returnLastUncollidableBlock ? result : null;
            }
            return null;
        }
        return null;
    }

    private static Tuple<Double, Boolean> step(int v1, int v2) {
        boolean flag = true;
        double d = 999.0;
        if (v2 > v1) {
            d = (double)v1 + 1.0;
        } else if (v2 < v1) {
            d = (double)v1 + 0.0;
        } else {
            flag = false;
        }
        return new Tuple((Object)d, (Object)flag);
    }

    public static class PredicateInstanceOf<E extends Entity>
    implements Predicate<E> {
        private final Class<E> entityClass;

        public PredicateInstanceOf(Class<E> entityClass) {
            this.entityClass = entityClass;
        }

        public boolean apply(@Nullable Entity e) {
            return e != null && this.entityClass.isAssignableFrom(e.getClass());
        }
    }
}

