/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityLib;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static <T> void forEachIn(Object from, Class<T> type, Consumer<T> consumer) {
        Object target = from instanceof Class ? null : from;
        ReflectionHelper.forEachFieldIn(from, field -> {
            try {
                field.setAccessible(true);
                Object obj = field.get(target);
                if (obj != null && type.isAssignableFrom(obj.getClass())) {
                    consumer.accept(type.cast(obj));
                }
            }
            catch (IllegalAccessException e) {
                InfinityLib.instance.getLogger().debug("ReflectionHelper.forEachIn() Skipping Field: \"" + field.getName() + "\" in Class: \"" + from.getClass().getCanonicalName() + "\"!", new Object[0]);
            }
        });
    }

    public static <T, A extends Annotation> void forEachIn(Object from, Class<T> type, Class<A> annotation, BiConsumer<T, A> consumer) {
        Object target = from instanceof Class ? null : from;
        ReflectionHelper.forEachFieldIn(from, annotation, (field, anno) -> {
            try {
                field.setAccessible(true);
                Object obj = field.get(target);
                if (obj != null && type.isAssignableFrom(obj.getClass())) {
                    consumer.accept(type.cast(obj), anno);
                }
            }
            catch (IllegalAccessException e) {
                InfinityLib.instance.getLogger().debug("ReflectionHelper.forEachIn() Skipping Field: \"" + field.getName() + "\" in Class: \"" + from.getClass().getCanonicalName() + "\"!", new Object[0]);
            }
        });
    }

    public static <A extends Annotation> void forEachFieldIn(Object from, Class<A> annotation, BiConsumer<Field, A> consumer) {
        ReflectionHelper.forEachFieldIn(from, field -> {
            if (field.isAnnotationPresent(annotation)) {
                consumer.accept((Field)field, (Object)field.getAnnotation(annotation));
            }
        });
    }

    public static void forEachFieldIn(Object from, Consumer<Field> consumer) {
        boolean isInstance = !(from instanceof Class);
        Class clazz = isInstance ? from.getClass() : (Class)from;
        for (Field f : clazz.getDeclaredFields()) {
            if (!isInstance && !Modifier.isStatic(f.getModifiers())) continue;
            consumer.accept(f);
        }
    }
}

