/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.api.audio;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import pl.asie.charset.api.audio.AudioAPI;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;

public abstract class AudioSink
implements IAudioReceiver {
    public abstract World getWorld();

    public abstract Vec3d getPos();

    public abstract float getDistance();

    public abstract float getVolume();

    @Override
    public boolean receive(AudioPacket packet) {
        return packet.add(this);
    }

    public void writeData(ByteBuf buffer) {
        buffer.writeShort(AudioAPI.SINK_REGISTRY.getId(this.getClass()));
    }

    public void readData(ByteBuf buffer) {
    }

    public static AudioSink create(ByteBuf buffer) {
        try {
            AudioSink sink = AudioAPI.SINK_REGISTRY.get(buffer.readUnsignedShort()).newInstance();
            sink.readData(buffer);
            return sink;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

