/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.note;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.note.PacketNoteParticle;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.audio.AudioDataSound;
import pl.asie.charset.lib.capability.DefaultAudioSource;
import pl.asie.charset.lib.network.Packet;

public class NoteBlockManager {
    private static final Map<Predicate<IBlockState>, SoundEvent> INSTRUMENTS = new HashMap<Predicate<IBlockState>, SoundEvent>();
    private static final SoundEvent DEFAULT_INSTRUMENT;
    private static final ResourceLocation NOTE_SOURCE_KEY;

    public static SoundEvent getSound(IBlockState state) {
        for (Predicate<IBlockState> predicate : INSTRUMENTS.keySet()) {
            if (!predicate.apply((Object)state)) continue;
            return INSTRUMENTS.get(predicate);
        }
        return DEFAULT_INSTRUMENT;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onNoteEvent(NoteBlockEvent.Play event) {
        event.setCanceled(true);
        World worldIn = event.getWorld();
        BlockPos pos = event.getPos();
        SoundEvent sound = NoteBlockManager.getSound(worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)));
        int param = event.getVanillaNoteId();
        float pitch = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
        if (!worldIn.field_72995_K) {
            TileEntity note = worldIn.func_175625_s(pos);
            if (note != null && note.hasCapability(Capabilities.AUDIO_SOURCE, null)) {
                AudioDataSound dataSound = new AudioDataSound(sound.func_187503_a().toString(), pitch);
                AudioPacket packet = new AudioPacket(dataSound, 1.0f);
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TileEntity tile = event.getWorld().func_175625_s(pos.func_177972_a(facing));
                    if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())) continue;
                    ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())).receive(packet);
                }
                if (packet.getSinkCount() > 0) {
                    packet.send();
                    return;
                }
            }
            worldIn.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 3.0f, pitch);
            ModCharsetAudio.packet.sendToAllAround((Packet)new PacketNoteParticle(note, param), note, 32.0);
        }
    }

    @SubscribeEvent
    public void onAttach(AttachCapabilitiesEvent.TileEntity event) {
        if (event.getTileEntity() instanceof TileEntityNote) {
            event.addCapability(NOTE_SOURCE_KEY, new ICapabilityProvider(){
                private final DefaultAudioSource source = new DefaultAudioSource();

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == Capabilities.AUDIO_SOURCE;
                }

                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == Capabilities.AUDIO_SOURCE ? Capabilities.AUDIO_SOURCE.cast((Object)this.source) : null);
                }
            });
        }
    }

    static {
        NOTE_SOURCE_KEY = new ResourceLocation("charsetaudio:noteSource");
        DEFAULT_INSTRUMENT = SoundEvents.field_187682_dG;
        INSTRUMENTS.put((Predicate<IBlockState>)((Predicate)input -> input.func_185904_a() == Material.field_151576_e), SoundEvents.field_187676_dE);
        INSTRUMENTS.put((Predicate<IBlockState>)((Predicate)input -> input.func_185904_a() == Material.field_151595_p), SoundEvents.field_187688_dI);
        INSTRUMENTS.put((Predicate<IBlockState>)((Predicate)input -> input.func_185904_a() == Material.field_151592_s), SoundEvents.field_187685_dH);
        INSTRUMENTS.put((Predicate<IBlockState>)((Predicate)input -> input.func_185904_a() == Material.field_151575_d), SoundEvents.field_187679_dF);
    }
}

